<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Módulo de Fidelización - SISCONECTA ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .main-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: linear-gradient(180deg, #2c3e50 0%, #34495e 100%);
            color: white;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
            transition: all 0.3s ease;
        }
        
        .sidebar.collapsed {
            width: 70px;
        }
        
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            text-align: center;
        }
        
        .sidebar-header h4 {
            margin: 0;
            font-weight: 600;
            transition: opacity 0.3s ease;
        }
        
        .sidebar.collapsed .sidebar-header h4 {
            opacity: 0;
        }
        
        .sidebar-toggle {
            position: absolute;
            top: 15px;
            right: 10px;
            background: rgba(255,255,255,0.1);
            border: none;
            color: white;
            padding: 5px 8px;
            border-radius: 4px;
            cursor: pointer;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-section {
            margin-bottom: 30px;
        }
        
        .menu-title {
            padding: 0 20px 10px 20px;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: rgba(255,255,255,0.6);
            font-weight: 600;
            transition: opacity 0.3s ease;
        }
        
        .sidebar.collapsed .menu-title {
            opacity: 0;
            height: 0;
            padding: 0;
            margin: 0;
        }
        
        .menu-item {
            display: block;
            padding: 12px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: all 0.3s ease;
            border-left: 3px solid transparent;
            position: relative;
        }
        
        .menu-item:hover {
            background: rgba(255,255,255,0.1);
            color: white;
            border-left-color: #e74c3c;
        }
        
        .menu-item.active {
            background: rgba(231,76,60,0.2);
            color: white;
            border-left-color: #e74c3c;
        }
        
        .menu-item i {
            width: 20px;
            margin-right: 15px;
            text-align: center;
        }
        
        .sidebar.collapsed .menu-item {
            padding: 12px;
            text-align: center;
        }
        
        .sidebar.collapsed .menu-item span {
            display: none;
        }
        
        .main-content {
            flex: 1;
            margin-left: 280px;
            padding: 20px;
            transition: all 0.3s ease;
        }
        
        .main-content.expanded {
            margin-left: 70px;
        }
        
        .header-section {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .header-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin: 0;
            color: #2c3e50;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .header-actions {
            display: flex;
            gap: 15px;
        }
        
        .btn-header {
            background: linear-gradient(45deg, #e74c3c, #c0392b);
            border: none;
            color: white;
            border-radius: 8px;
            padding: 10px 20px;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 500;
            display: inline-block;
        }
        
        .btn-header:hover {
            transform: translateY(-1px);
            box-shadow: 0 5px 15px rgba(231,76,60,0.3);
            color: white;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 25px;
        }
        
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            border-left: 5px solid;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            animation: shimmer 2s infinite;
        }
        
        @keyframes shimmer {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.15);
        }
        
        .stat-card.loyalty { border-left-color: #e74c3c; }
        .stat-card.gold { border-left-color: #f39c12; }
        .stat-card.success { border-left-color: #27ae60; }
        .stat-card.info { border-left-color: #3498db; }
        .stat-card.purple { border-left-color: #9b59b6; }
        .stat-card.dark { border-left-color: #34495e; }
        
        .stat-value {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
            line-height: 1;
        }
        
        .stat-label {
            color: #666;
            font-weight: 500;
            font-size: 0.9rem;
            margin-bottom: 10px;
        }
        
        .stat-icon {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 2.5rem;
            opacity: 0.2;
            color: #2c3e50;
        }
        
        .stat-trend {
            font-size: 0.8rem;
            color: #27ae60;
            font-weight: 600;
        }
        
        .stat-trend.negative {
            color: #e74c3c;
        }
        
        .content-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            margin-bottom: 25px;
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f8f9fa;
        }
        
        .card-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #2c3e50;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .level-badge {
            padding: 8px 16px;
            border-radius: 25px;
            font-size: 0.8rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .level-bronze {
            background: linear-gradient(45deg, #cd7f32, #b8691a);
            color: white;
        }
        
        .level-silver {
            background: linear-gradient(45deg, #c0c0c0, #a8a8a8);
            color: white;
        }
        
        .level-gold {
            background: linear-gradient(45deg, #ffd700, #ffb347);
            color: #8b4513;
        }
        
        .level-platinum {
            background: linear-gradient(45deg, #e5e4e2, #d3d3d3);
            color: #2c3e50;
        }
        
        .level-diamond {
            background: linear-gradient(45deg, #b9f2ff, #87ceeb);
            color: #191970;
        }
        
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 25px;
        }
        
        .quick-action {
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            text-decoration: none;
            color: #2c3e50;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .quick-action:hover {
            border-color: #e74c3c;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(231,76,60,0.2);
            color: #2c3e50;
        }
        
        .quick-action i {
            font-size: 2rem;
            margin-bottom: 10px;
            color: #e74c3c;
        }
        
        .quick-action h6 {
            margin: 0;
            font-weight: 600;
        }
        
        .points-counter {
            background: linear-gradient(45deg, #e74c3c, #c0392b);
            color: white;
            padding: 15px 20px;
            border-radius: 50px;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-weight: 600;
        }
        
        .reward-card {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            transition: all 0.3s ease;
            margin-bottom: 15px;
        }
        
        .reward-card:hover {
            border-color: #e74c3c;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(231,76,60,0.2);
        }
        
        .reward-image {
            width: 80px;
            height: 80px;
            background: #f8f9fa;
            border-radius: 10px;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: #e74c3c;
        }
        
        .progress-container {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .progress {
            height: 12px;
            border-radius: 6px;
            overflow: hidden;
            margin-bottom: 10px;
        }
        
        .progress-bar {
            transition: width 0.6s ease;
        }
        
        .table-container {
            overflow-x: auto;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        
        .table {
            margin: 0;
            background: white;
        }
        
        .table th {
            background: #f8f9fa;
            border-top: none;
            border-bottom: 2px solid #dee2e6;
            font-weight: 600;
            color: #2c3e50;
            padding: 15px 12px;
            white-space: nowrap;
        }
        
        .table td {
            padding: 15px 12px;
            vertical-align: middle;
            border-top: 1px solid #f1f3f4;
        }
        
        .table tbody tr:hover {
            background: #f8f9fa;
        }
        
        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .modal-content {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .modal-header {
            background: linear-gradient(45deg, #e74c3c, #c0392b);
            color: white;
            border-radius: 15px 15px 0 0;
            border-bottom: none;
        }
        
        .form-control, .form-select {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #e74c3c;
            box-shadow: 0 0 0 0.2rem rgba(231,76,60,0.25);
        }
        
        .btn-primary {
            background: linear-gradient(45deg, #e74c3c, #c0392b);
            border: none;
            border-radius: 8px;
            padding: 12px 25px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(231,76,60,0.3);
        }
        
        .floating-action {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 60px;
            height: 60px;
            background: linear-gradient(45deg, #e74c3c, #c0392b);
            border: none;
            border-radius: 50%;
            color: white;
            font-size: 1.5rem;
            box-shadow: 0 5px 15px rgba(231,76,60,0.3);
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 1000;
        }
        
        .floating-action:hover {
            transform: scale(1.1);
            box-shadow: 0 8px 25px rgba(231,76,60,0.4);
        }
        
        .campaign-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
        }
        
        .campaign-card::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        
        .nav-tabs .nav-link {
            border: none;
            border-radius: 8px 8px 0 0;
            margin-right: 5px;
            color: #666;
            font-weight: 500;
        }
        
        .nav-tabs .nav-link.active {
            background: #e74c3c;
            color: white;
            border-color: #e74c3c;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .quick-actions {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Sidebar -->
        <div class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <button class="sidebar-toggle" onclick="toggleSidebar()">
                    <i class="fas fa-bars"></i>
                </button>
                <h4>Fidelización</h4>
            </div>
            
            <div class="sidebar-menu">
                <div class="menu-section">
                    <div class="menu-title">Dashboard</div>
                    <a href="#dashboard" class="menu-item active" onclick="showSection('dashboard')">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="#metricas" class="menu-item" onclick="showSection('metricas')">
                        <i class="fas fa-chart-line"></i>
                        <span>Métricas</span>
                    </a>
                </div>
                
                <div class="menu-section">
                    <div class="menu-title">Clientes</div>
                    <a href="#clientes" class="menu-item" onclick="showSection('clientes')">
                        <i class="fas fa-users"></i>
                        <span>Gestión de Clientes</span>
                    </a>
                    <a href="#puntos" class="menu-item" onclick="showSection('puntos')">
                        <i class="fas fa-coins"></i>
                        <span>Puntos y Niveles</span>
                    </a>
                    <a href="#historial" class="menu-item" onclick="showSection('historial')">
                        <i class="fas fa-history"></i>
                        <span>Historial</span>
                    </a>
                </div>
                
                <div class="menu-section">
                    <div class="menu-title">Recompensas</div>
                    <a href="#recompensas" class="menu-item" onclick="showSection('recompensas')">
                        <i class="fas fa-gift"></i>
                        <span>Catálogo</span>
                    </a>
                    <a href="#canjes" class="menu-item" onclick="showSection('canjes')">
                        <i class="fas fa-exchange-alt"></i>
                        <span>Canjes</span>
                    </a>
                </div>
                
                <div class="menu-section">
                    <div class="menu-title">Marketing</div>
                    <a href="#campanas" class="menu-item" onclick="showSection('campanas')">
                        <i class="fas fa-bullhorn"></i>
                        <span>Campañas</span>
                    </a>
                    <a href="#notificaciones" class="menu-item" onclick="showSection('notificaciones')">
                        <i class="fas fa-bell"></i>
                        <span>Notificaciones</span>
                    </a>
                </div>
                
                <div class="menu-section">
                    <div class="menu-title">Configuración</div>
                    <a href="#configuracion" class="menu-item" onclick="showSection('configuracion')">
                        <i class="fas fa-cog"></i>
                        <span>Configuración</span>
                    </a>
                    <a href="#reportes" class="menu-item" onclick="showSection('reportes')">
                        <i class="fas fa-file-alt"></i>
                        <span>Reportes</span>
                    </a>
                </div>
                
                <div class="menu-section">
                    <div class="menu-title">Sistema</div>
                    <a href="inventario_avanzado.php" class="menu-item">
                        <i class="fas fa-boxes"></i>
                        <span>Inventario</span>
                    </a>
                    <a href="dashboard.php" class="menu-item">
                        <i class="fas fa-home"></i>
                        <span>ERP Principal</span>
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="main-content" id="mainContent">
            <!-- Header -->
            <div class="header-section">
                <h1 class="header-title">
                    <i class="fas fa-heart"></i>
                    <span id="sectionTitle">Dashboard de Fidelización</span>
                </h1>
                <div class="header-actions">
                    <a href="dashboard.php" class="btn-header">
                        <i class="fas fa-arrow-left"></i> Volver al ERP
                    </a>
                    <button class="btn-header" data-bs-toggle="modal" data-bs-target="#modalNuevoCliente">
                        <i class="fas fa-user-plus"></i> Nuevo Cliente
                    </button>
                    <button class="btn-header" data-bs-toggle="modal" data-bs-target="#modalAccionRapida">
                        <i class="fas fa-bolt"></i> Acción Rápida
                    </button>
                </div>
            </div>

            <!-- Dashboard Section -->
            <div id="dashboard-section" class="section-content">
                <!-- Stats Grid -->
                <div class="stats-grid">
                    <div class="stat-card loyalty">
                        <div class="stat-value">2,847</div>
                        <div class="stat-label">Clientes Activos</div>
                        <div class="stat-trend">+12% este mes</div>
                        <i class="fas fa-users stat-icon"></i>
                    </div>
                    
                    <div class="stat-card gold">
                        <div class="stat-value">156,789</div>
                        <div class="stat-label">Puntos Acumulados</div>
                        <div class="stat-trend">+8% vs mes anterior</div>
                        <i class="fas fa-coins stat-icon"></i>
                    </div>
                    
                    <div class="stat-card success">
                        <div class="stat-value">$45,230</div>
                        <div class="stat-label">Valor Canjeado</div>
                        <div class="stat-trend">+23% incremento</div>
                        <i class="fas fa-gift stat-icon"></i>
                    </div>
                    
                    <div class="stat-card info">
                        <div class="stat-value">89.5%</div>
                        <div class="stat-label">Tasa de Retención</div>
                        <div class="stat-trend">+5.2% mejora</div>
                        <i class="fas fa-chart-line stat-icon"></i>
                    </div>
                    
                    <div class="stat-card purple">
                        <div class="stat-value">3.2</div>
                        <div class="stat-label">Compras Promedio</div>
                        <div class="stat-trend">Por cliente/mes</div>
                        <i class="fas fa-shopping-cart stat-icon"></i>
                    </div>
                    
                    <div class="stat-card dark">
                        <div class="stat-value">47</div>
                        <div class="stat-label">Campañas Activas</div>
                        <div class="stat-trend">15 nuevas</div>
                        <i class="fas fa-bullhorn stat-icon"></i>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="quick-actions">
                    <div class="quick-action" data-bs-toggle="modal" data-bs-target="#modalAsignarPuntos">
                        <i class="fas fa-plus-circle"></i>
                        <h6>Asignar Puntos</h6>
                    </div>
                    <div class="quick-action" data-bs-toggle="modal" data-bs-target="#modalCanjearRecompensa">
                        <i class="fas fa-gift"></i>
                        <h6>Canjear Recompensa</h6>
                    </div>
                    <div class="quick-action" data-bs-toggle="modal" data-bs-target="#modalNuevaCampana">
                        <i class="fas fa-rocket"></i>
                        <h6>Nueva Campaña</h6>
                    </div>
                    <div class="quick-action" onclick="generarReporte()">
                        <i class="fas fa-chart-bar"></i>
                        <h6>Generar Reporte</h6>
                    </div>
                    <div class="quick-action" data-bs-toggle="modal" data-bs-target="#modalEnviarNotificacion">
                        <i class="fas fa-envelope"></i>
                        <h6>Enviar Notificación</h6>
                    </div>
                    <div class="quick-action" onclick="exportarDatos()">
                        <i class="fas fa-download"></i>
                        <h6>Exportar Datos</h6>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-8">
                        <!-- Distribución de Niveles -->
                        <div class="content-card">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-layer-group"></i>
                                    Distribución por Niveles
                                </h3>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="progress-container">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="level-badge level-bronze">Bronce</span>
                                            <span class="fw-bold">1,247 clientes</span>
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 44%; background: linear-gradient(45deg, #cd7f32, #b8691a);"></div>
                                        </div>
                                        <small class="text-muted">44% del total</small>
                                    </div>
                                    
                                    <div class="progress-container">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="level-badge level-silver">Plata</span>
                                            <span class="fw-bold">856 clientes</span>
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 30%; background: linear-gradient(45deg, #c0c0c0, #a8a8a8);"></div>
                                        </div>
                                        <small class="text-muted">30% del total</small>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="progress-container">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="level-badge level-gold">Oro</span>
                                            <span class="fw-bold">512 clientes</span>
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 18%; background: linear-gradient(45deg, #ffd700, #ffb347);"></div>
                                        </div>
                                        <small class="text-muted">18% del total</small>
                                    </div>
                                    
                                    <div class="progress-container">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="level-badge level-platinum">Platino</span>
                                            <span class="fw-bold">189 clientes</span>
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 7%; background: linear-gradient(45deg, #e5e4e2, #d3d3d3);"></div>
                                        </div>
                                        <small class="text-muted">7% del total</small>
                                    </div>
                                    
                                    <div class="progress-container">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="level-badge level-diamond">Diamante</span>
                                            <span class="fw-bold">43 clientes</span>
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 1%; background: linear-gradient(45deg, #b9f2ff, #87ceeb);"></div>
                                        </div>
                                        <small class="text-muted">1% del total (VIP)</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Transacciones Recientes -->
                        <div class="content-card">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-exchange-alt"></i>
                                    Transacciones Recientes
                                </h3>
                            </div>
                            
                            <div class="table-container">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Cliente</th>
                                            <th>Tipo</th>
                                            <th>Puntos</th>
                                            <th>Concepto</th>
                                            <th>Fecha</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <div class="rounded-circle bg-primary d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <span class="text-white fw-bold">ML</span>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold">María López</div>
                                                        <small class="text-muted">Oro</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><span class="badge bg-success">Ganó</span></td>
                                            <td><strong>+250</strong></td>
                                            <td>Compra #12345</td>
                                            <td>Hace 2 horas</td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <div class="rounded-circle bg-success d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <span class="text-white fw-bold">CG</span>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold">Carlos García</div>
                                                        <small class="text-muted">Plata</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><span class="badge bg-danger">Canjeó</span></td>
                                            <td><strong>-500</strong></td>
                                            <td>Descuento 10%</td>
                                            <td>Hace 5 horas</td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <div class="rounded-circle bg-warning d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <span class="text-white fw-bold">AR</span>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold">Ana Rodríguez</div>
                                                        <small class="text-muted">Platino</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><span class="badge bg-info">Bonus</span></td>
                                            <td><strong>+100</strong></td>
                                            <td>Cumpleaños</td>
                                            <td>Hace 1 día</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4">
                        <!-- Top Clientes -->
                        <div class="content-card">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-crown"></i>
                                    Top Clientes del Mes
                                </h3>
                            </div>
                            
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <i class="fas fa-medal text-warning" style="font-size: 1.5rem;"></i>
                                        </div>
                                        <div>
                                            <div class="fw-bold">Isabella Martín</div>
                                            <small class="text-muted">Diamante • 2,847 pts</small>
                                        </div>
                                    </div>
                                    <div class="points-counter">
                                        <i class="fas fa-coins"></i>
                                        <span>2,847</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <i class="fas fa-medal text-secondary" style="font-size: 1.5rem;"></i>
                                        </div>
                                        <div>
                                            <div class="fw-bold">Roberto Silva</div>
                                            <small class="text-muted">Platino • 1,923 pts</small>
                                        </div>
                                    </div>
                                    <div class="points-counter">
                                        <i class="fas fa-coins"></i>
                                        <span>1,923</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <i class="fas fa-medal text-warning" style="font-size: 1.5rem; opacity: 0.7;"></i>
                                        </div>
                                        <div>
                                            <div class="fw-bold">Carmen Torres</div>
                                            <small class="text-muted">Oro • 1,567 pts</small>
                                        </div>
                                    </div>
                                    <div class="points-counter">
                                        <i class="fas fa-coins"></i>
                                        <span>1,567</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Campaña Activa -->
                        <div class="campaign-card">
                            <h4><i class="fas fa-fire"></i> Campaña Activa</h4>
                            <h5 class="mb-3">¡Doble Puntos de Navidad!</h5>
                            <p class="mb-3">Hasta el 31 de diciembre, todos los clientes obtienen el doble de puntos en sus compras.</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <small>Termina en: 15 días</small>
                                <button class="btn btn-light btn-sm">Ver Detalles</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Otras secciones serían añadidas aquí -->
            <div id="clientes-section" class="section-content" style="display: none;">
                <div class="content-card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-users"></i>
                            Gestión de Clientes
                        </h3>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalNuevoCliente">
                            <i class="fas fa-plus"></i> Nuevo Cliente
                        </button>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <input type="text" class="form-control" placeholder="Buscar cliente...">
                        </div>
                        <div class="col-md-3">
                            <select class="form-select">
                                <option value="">Todos los niveles</option>
                                <option value="bronce">Bronce</option>
                                <option value="plata">Plata</option>
                                <option value="oro">Oro</option>
                                <option value="platino">Platino</option>
                                <option value="diamante">Diamante</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select">
                                <option value="">Estado</option>
                                <option value="activo">Activo</option>
                                <option value="inactivo">Inactivo</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-outline-secondary w-100">
                                <i class="fas fa-filter"></i> Filtrar
                            </button>
                        </div>
                    </div>
                    
                    <div class="table-container">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Cliente</th>
                                    <th>Email</th>
                                    <th>Nivel</th>
                                    <th>Puntos</th>
                                    <th>Última Compra</th>
                                    <th>Estado</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Datos de clientes serían cargados dinámicamente -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Más secciones aquí... -->
        </div>
    </div>

    <!-- Modales -->
    
    <!-- Modal Nuevo Cliente -->
    <div class="modal fade" id="modalNuevoCliente" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-user-plus"></i> Nuevo Cliente
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="">
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Nombre *</label>
                                <input type="text" class="form-control" name="nombre" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Apellido *</label>
                                <input type="text" class="form-control" name="apellido" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email *</label>
                                <input type="email" class="form-control" name="email" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Teléfono</label>
                                <input type="tel" class="form-control" name="telefono">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Fecha de Nacimiento</label>
                                <input type="date" class="form-control" name="fecha_nacimiento">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Género</label>
                                <select class="form-select" name="genero">
                                    <option value="">Seleccionar...</option>
                                    <option value="M">Masculino</option>
                                    <option value="F">Femenino</option>
                                    <option value="O">Otro</option>
                                </select>
                            </div>
                            <div class="col-12">
                                <label class="form-label">Dirección</label>
                                <textarea class="form-control" name="direccion" rows="2"></textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Puntos Iniciales</label>
                                <input type="number" class="form-control" name="puntos_iniciales" value="0" min="0">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Nivel Inicial</label>
                                <select class="form-select" name="nivel_inicial">
                                    <option value="bronce">Bronce</option>
                                    <option value="plata">Plata</option>
                                    <option value="oro">Oro</option>
                                    <option value="platino">Platino</option>
                                    <option value="diamante">Diamante</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" name="crear_cliente" class="btn btn-primary">
                            <i class="fas fa-save"></i> Crear Cliente
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Asignar Puntos -->
    <div class="modal fade" id="modalAsignarPuntos" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-coins"></i> Asignar Puntos
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Cliente *</label>
                            <select class="form-select" name="cliente_id" required>
                                <option value="">Seleccionar cliente...</option>
                                <!-- Clientes dinámicos -->
                            </select>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Tipo de Operación *</label>
                                <select class="form-select" name="tipo_operacion" required>
                                    <option value="">Seleccionar...</option>
                                    <option value="asignar">Asignar Puntos</option>
                                    <option value="quitar">Quitar Puntos</option>
                                    <option value="ajuste">Ajuste</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Cantidad de Puntos *</label>
                                <input type="number" class="form-control" name="puntos" min="1" required>
                            </div>
                        </div>
                        <div class="mt-3">
                            <label class="form-label">Motivo *</label>
                            <select class="form-select" name="motivo" required>
                                <option value="">Seleccionar motivo...</option>
                                <option value="compra">Compra</option>
                                <option value="bonus">Bonus</option>
                                <option value="cumpleanos">Cumpleaños</option>
                                <option value="referido">Referido</option>
                                <option value="promocion">Promoción</option>
                                <option value="ajuste">Ajuste manual</option>
                                <option value="otro">Otro</option>
                            </select>
                        </div>
                        <div class="mt-3">
                            <label class="form-label">Observaciones</label>
                            <textarea class="form-control" name="observaciones" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" name="asignar_puntos" class="btn btn-primary">
                            <i class="fas fa-check"></i> Procesar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Canjear Recompensa -->
    <div class="modal fade" id="modalCanjearRecompensa" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-gift"></i> Canjear Recompensa
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="">
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Cliente *</label>
                                <select class="form-select" name="cliente_id" required>
                                    <option value="">Seleccionar cliente...</option>
                                    <!-- Clientes dinámicos -->
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Puntos Disponibles</label>
                                <input type="text" class="form-control" id="puntosDisponibles" readonly>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <h6>Recompensas Disponibles</h6>
                            <div class="row g-3" id="recompensasDisponibles">
                                <div class="col-md-6">
                                    <div class="reward-card">
                                        <div class="reward-image">
                                            <i class="fas fa-percentage"></i>
                                        </div>
                                        <h6>Descuento 10%</h6>
                                        <p class="text-muted">500 puntos</p>
                                        <button type="button" class="btn btn-outline-primary btn-sm" onclick="seleccionarRecompensa(1, 500)">
                                            Seleccionar
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="reward-card">
                                        <div class="reward-image">
                                            <i class="fas fa-coffee"></i>
                                        </div>
                                        <h6>Café Gratis</h6>
                                        <p class="text-muted">200 puntos</p>
                                        <button type="button" class="btn btn-outline-primary btn-sm" onclick="seleccionarRecompensa(2, 200)">
                                            Seleccionar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <input type="hidden" name="recompensa_id" id="recompensaSeleccionada">
                        <input type="hidden" name="puntos_requeridos" id="puntosRequeridos">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" name="canjear_recompensa" class="btn btn-primary" disabled id="btnCanjear">
                            <i class="fas fa-check"></i> Canjear
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Acción Rápida -->
    <div class="modal fade" id="modalAccionRapida" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-bolt"></i> Acciones Rápidas
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <button class="btn btn-outline-success w-100" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#modalAsignarPuntos">
                                <i class="fas fa-plus-circle"></i><br>
                                Asignar Puntos
                            </button>
                        </div>
                        <div class="col-md-6">
                            <button class="btn btn-outline-warning w-100" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#modalCanjearRecompensa">
                                <i class="fas fa-gift"></i><br>
                                Canjear Recompensa
                            </button>
                        </div>
                        <div class="col-md-6">
                            <button class="btn btn-outline-info w-100" onclick="consultarCliente()">
                                <i class="fas fa-search"></i><br>
                                Consultar Cliente
                            </button>
                        </div>
                        <div class="col-md-6">
                            <button class="btn btn-outline-primary w-100" onclick="generarReporte()">
                                <i class="fas fa-chart-bar"></i><br>
                                Generar Reporte
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Floating Action Button -->
    <button class="floating-action" data-bs-toggle="modal" data-bs-target="#modalAccionRapida">
        <i class="fas fa-bolt"></i>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle sidebar
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            
            sidebar.classList.toggle('collapsed');
            mainContent.classList.toggle('expanded');
        }
        
        // Show section
        function showSection(sectionName) {
            // Hide all sections
            document.querySelectorAll('.section-content').forEach(section => {
                section.style.display = 'none';
            });
            
            // Show selected section
            const targetSection = document.getElementById(sectionName + '-section');
            if (targetSection) {
                targetSection.style.display = 'block';
            }
            
            // Update active menu item
            document.querySelectorAll('.menu-item').forEach(item => {
                item.classList.remove('active');
            });
            event.target.closest('.menu-item').classList.add('active');
            
            // Update section title
            const titles = {
                'dashboard': 'Dashboard de Fidelización',
                'clientes': 'Gestión de Clientes',
                'puntos': 'Puntos y Niveles',
                'recompensas': 'Catálogo de Recompensas',
                'campanas': 'Campañas de Marketing',
                'configuracion': 'Configuración del Programa',
                'reportes': 'Reportes y Análisis'
            };
            
            document.getElementById('sectionTitle').textContent = titles[sectionName] || 'Sistema de Fidelización';
        }
        
        // Seleccionar recompensa
        function seleccionarRecompensa(id, puntos) {
            document.getElementById('recompensaSeleccionada').value = id;
            document.getElementById('puntosRequeridos').value = puntos;
            document.getElementById('btnCanjear').disabled = false;
            
            // Highlight selected reward
            document.querySelectorAll('.reward-card').forEach(card => {
                card.style.borderColor = '#e9ecef';
            });
            event.target.closest('.reward-card').style.borderColor = '#e74c3c';
        }
        
        // Consultar cliente
        function consultarCliente() {
            const cliente = prompt('Ingrese email o teléfono del cliente:');
            if (cliente) {
                // Aquí iría la lógica de consulta
                alert('Funcionalidad de consulta - Cliente: ' + cliente);
            }
        }
        
        // Generar reporte
        function generarReporte() {
            alert('Generando reporte de fidelización...');
        }
        
        // Exportar datos
        function exportarDatos() {
            alert('Exportando datos del programa de fidelización...');
        }
        
        // Auto-refresh cada 5 minutos
        setInterval(function() {
            // Actualizar métricas en tiempo real
            console.log('Actualizando métricas...');
        }, 300000);
        
        // Responsive sidebar para móviles
        if (window.innerWidth <= 768) {
            document.getElementById('sidebar').classList.add('collapsed');
            document.getElementById('mainContent').classList.add('expanded');
        }
        
        // Animaciones de entrada
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.stat-card, .content-card');
            cards.forEach((card, index) => {
                setTimeout(() => {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';
                    card.style.transition = 'all 0.5s ease';
                    
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 50);
                }, index * 100);
            });
        });

        // Validación de formularios
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function(e) {
                const required = this.querySelectorAll('[required]');
                let valid = true;
                
                required.forEach(field => {
                    if (!field.value.trim()) {
                        field.classList.add('is-invalid');
                        valid = false;
                    } else {
                        field.classList.remove('is-invalid');
                    }
                });
                
                if (!valid) {
                    e.preventDefault();
                    alert('Por favor complete todos los campos obligatorios');
                }
            });
        });

        // Simulación de datos en tiempo real
        function actualizarMetricas() {
            // Simular actualización de métricas
            const elementos = [
                { id: 'clientesActivos', incremento: Math.floor(Math.random() * 5) },
                { id: 'puntosAcumulados', incremento: Math.floor(Math.random() * 100) },
                { id: 'valorCanjeado', incremento: Math.floor(Math.random() * 50) }
            ];
            
            elementos.forEach(elemento => {
                // Aquí se actualizarían los valores reales
                console.log(`Actualizando ${elemento.id}: +${elemento.incremento}`);
            });
        }

        // Ejecutar actualización cada minuto
        setInterval(actualizarMetricas, 60000);
    </script>
</body>
</html>