<?php
// MÓDULO HOJA DE TRABAJO - SISCONECTA ERP
// hoja_trabajo.php

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar sesión activa
if (!isset($_SESSION['user_id']) || !isset($_SESSION['empresa_id'])) {
    header('Location: login.php');
    exit;
}

// Configuración de base de datos
$host = 'localhost';
$dbname = 'conectae_sisconecta';
$username = 'conectae_sisconectauser';
$password = 'pt125824caraud';

$mensaje = '';
$tipo_mensaje = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $empresa_id = $_SESSION['empresa_id'];
    
    // Verificar estado de empresa
    $stmt = $pdo->prepare("SELECT * FROM empresas WHERE id = ? AND estado = 'activo'");
    $stmt->execute([$empresa_id]);
    $empresa = $stmt->fetch();
    
    if (!$empresa) {
        session_destroy();
        header('Location: login.php?error=empresa_inactiva');
        exit;
    }
    
    // Crear tabla de hojas de trabajo si no existe
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS hojas_trabajo (
            id INT AUTO_INCREMENT PRIMARY KEY,
            empresa_id INT NOT NULL,
            nombre VARCHAR(255) NOT NULL,
            periodo VARCHAR(20) NOT NULL,
            fecha_desde DATE NOT NULL,
            fecha_hasta DATE NOT NULL,
            estado ENUM('borrador', 'finalizada') DEFAULT 'borrador',
            observaciones TEXT,
            fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            usuario_creacion INT NOT NULL,
            FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
            FOREIGN KEY (usuario_creacion) REFERENCES usuarios(id),
            INDEX idx_empresa_periodo (empresa_id, periodo)
        ) ENGINE=InnoDB
    ");
    
    // Crear tabla de ajustes de hoja de trabajo
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS hoja_trabajo_ajustes (
            id INT AUTO_INCREMENT PRIMARY KEY,
            hoja_trabajo_id INT NOT NULL,
            cuenta_contable VARCHAR(20) NOT NULL,
            nombre_cuenta VARCHAR(255) NOT NULL,
            saldo_inicial_debe DECIMAL(15,2) DEFAULT 0.00,
            saldo_inicial_haber DECIMAL(15,2) DEFAULT 0.00,
            ajuste_debe DECIMAL(15,2) DEFAULT 0.00,
            ajuste_haber DECIMAL(15,2) DEFAULT 0.00,
            saldo_ajustado_debe DECIMAL(15,2) DEFAULT 0.00,
            saldo_ajustado_haber DECIMAL(15,2) DEFAULT 0.00,
            balance_debe DECIMAL(15,2) DEFAULT 0.00,
            balance_haber DECIMAL(15,2) DEFAULT 0.00,
            resultado_debe DECIMAL(15,2) DEFAULT 0.00,
            resultado_haber DECIMAL(15,2) DEFAULT 0.00,
            observaciones TEXT,
            FOREIGN KEY (hoja_trabajo_id) REFERENCES hojas_trabajo(id) ON DELETE CASCADE,
            INDEX idx_hoja_cuenta (hoja_trabajo_id, cuenta_contable)
        ) ENGINE=InnoDB
    ");
    
    $accion = $_GET['accion'] ?? 'listar';
    $hoja_id = $_GET['id'] ?? null;
    
    // Crear nueva hoja de trabajo
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['crear_hoja'])) {
        $nombre = trim($_POST['nombre']);
        $periodo = trim($_POST['periodo']);
        $fecha_desde = $_POST['fecha_desde'];
        $fecha_hasta = $_POST['fecha_hasta'];
        $observaciones = trim($_POST['observaciones']);
        
        if (!empty($nombre) && !empty($periodo) && !empty($fecha_desde) && !empty($fecha_hasta)) {
            try {
                $pdo->beginTransaction();
                
                // Insertar hoja de trabajo
                $stmt = $pdo->prepare("
                    INSERT INTO hojas_trabajo (empresa_id, nombre, periodo, fecha_desde, fecha_hasta, observaciones, usuario_creacion) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)
                ");
                $stmt->execute([$empresa_id, $nombre, $periodo, $fecha_desde, $fecha_hasta, $observaciones, $_SESSION['user_id']]);
                $hoja_id = $pdo->lastInsertId();
                
                // Obtener saldos iniciales de todas las cuentas con movimientos
                $stmt = $pdo->prepare("
                    SELECT 
                        mc.cuenta_contable,
                        pc.nombre_cuenta,
                        pc.tipo_cuenta,
                        SUM(mc.debe) as total_debe,
                        SUM(mc.haber) as total_haber
                    FROM movimientos_contables mc
                    JOIN asientos_contables ac ON mc.asiento_id = ac.id
                    LEFT JOIN plan_cuentas pc ON mc.cuenta_contable = pc.codigo_cuenta AND (pc.empresa_id = ? OR pc.empresa_id IS NULL)
                    WHERE ac.empresa_id = ? 
                    AND ac.fecha <= ?
                    AND ac.estado = 'contabilizado'
                    GROUP BY mc.cuenta_contable, pc.nombre_cuenta, pc.tipo_cuenta
                    ORDER BY mc.cuenta_contable
                ");
                $stmt->execute([$empresa_id, $empresa_id, $fecha_hasta]);
                $saldos = $stmt->fetchAll();
                
                // Insertar los saldos iniciales en la hoja de trabajo
                foreach ($saldos as $saldo) {
                    $saldo_debe = 0;
                    $saldo_haber = 0;
                    
                    // Determinar el lado del saldo según el tipo de cuenta
                    $diferencia = $saldo['total_debe'] - $saldo['total_haber'];
                    
                    if (in_array($saldo['tipo_cuenta'], ['activo', 'gasto'])) {
                        // Cuentas de naturaleza deudora
                        if ($diferencia >= 0) {
                            $saldo_debe = $diferencia;
                        } else {
                            $saldo_haber = abs($diferencia);
                        }
                    } else {
                        // Cuentas de naturaleza acreedora (pasivo, patrimonio, ingreso)
                        if ($diferencia <= 0) {
                            $saldo_haber = abs($diferencia);
                        } else {
                            $saldo_debe = $diferencia;
                        }
                    }
                    
                    $stmt = $pdo->prepare("
                        INSERT INTO hoja_trabajo_ajustes 
                        (hoja_trabajo_id, cuenta_contable, nombre_cuenta, saldo_inicial_debe, saldo_inicial_haber, 
                         saldo_ajustado_debe, saldo_ajustado_haber, balance_debe, balance_haber, resultado_debe, resultado_haber) 
                        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ");
                    
                    // Para balance general (activo, pasivo, patrimonio)
                    $balance_debe = 0;
                    $balance_haber = 0;
                    $resultado_debe = 0;
                    $resultado_haber = 0;
                    
                    if (in_array($saldo['tipo_cuenta'], ['activo', 'pasivo', 'patrimonio'])) {
                        $balance_debe = $saldo_debe;
                        $balance_haber = $saldo_haber;
                    } else {
                        // Para estado de resultados (ingresos, gastos)
                        $resultado_debe = $saldo_debe;
                        $resultado_haber = $saldo_haber;
                    }
                    
                    $stmt->execute([
                        $hoja_id, 
                        $saldo['cuenta_contable'], 
                        $saldo['nombre_cuenta'] ?: 'Cuenta sin nombre',
                        $saldo_debe, 
                        $saldo_haber,
                        $saldo_debe, 
                        $saldo_haber,
                        $balance_debe,
                        $balance_haber,
                        $resultado_debe,
                        $resultado_haber
                    ]);
                }
                
                $pdo->commit();
                
                $mensaje = "Hoja de trabajo '$nombre' creada exitosamente";
                $tipo_mensaje = 'success';
                $accion = 'editar';
                
            } catch (Exception $e) {
                $pdo->rollBack();
                $mensaje = 'Error al crear hoja de trabajo: ' . $e->getMessage();
                $tipo_mensaje = 'danger';
            }
        } else {
            $mensaje = 'Complete todos los campos obligatorios';
            $tipo_mensaje = 'warning';
        }
    }
    
    // Guardar ajustes
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['guardar_ajustes'])) {
        $ajustes = json_decode($_POST['ajustes_data'], true);
        
        if (!empty($ajustes)) {
            try {
                $pdo->beginTransaction();
                
                foreach ($ajustes as $ajuste) {
                    $cuenta = $ajuste['cuenta'];
                    $ajuste_debe = floatval($ajuste['ajuste_debe']);
                    $ajuste_haber = floatval($ajuste['ajuste_haber']);
                    
                    // Obtener saldos iniciales
                    $stmt = $pdo->prepare("
                        SELECT saldo_inicial_debe, saldo_inicial_haber 
                        FROM hoja_trabajo_ajustes 
                        WHERE hoja_trabajo_id = ? AND cuenta_contable = ?
                    ");
                    $stmt->execute([$hoja_id, $cuenta]);
                    $saldos = $stmt->fetch();
                    
                    if ($saldos) {
                        // Calcular saldos ajustados
                        $saldo_ajustado_debe = $saldos['saldo_inicial_debe'] + $ajuste_debe;
                        $saldo_ajustado_haber = $saldos['saldo_inicial_haber'] + $ajuste_haber;
                        
                        // Actualizar ajustes
                        $stmt = $pdo->prepare("
                            UPDATE hoja_trabajo_ajustes 
                            SET ajuste_debe = ?, ajuste_haber = ?, 
                                saldo_ajustado_debe = ?, saldo_ajustado_haber = ?
                            WHERE hoja_trabajo_id = ? AND cuenta_contable = ?
                        ");
                        $stmt->execute([
                            $ajuste_debe, $ajuste_haber,
                            $saldo_ajustado_debe, $saldo_ajustado_haber,
                            $hoja_id, $cuenta
                        ]);
                    }
                }
                
                $pdo->commit();
                
                $mensaje = 'Ajustes guardados correctamente';
                $tipo_mensaje = 'success';
                
            } catch (Exception $e) {
                $pdo->rollBack();
                $mensaje = 'Error al guardar ajustes: ' . $e->getMessage();
                $tipo_mensaje = 'danger';
            }
        }
    }
    
    // Finalizar hoja de trabajo
    if (isset($_GET['finalizar']) && !empty($_GET['finalizar'])) {
        try {
            $stmt = $pdo->prepare("UPDATE hojas_trabajo SET estado = 'finalizada' WHERE id = ? AND empresa_id = ?");
            $stmt->execute([$_GET['finalizar'], $empresa_id]);
            
            $mensaje = 'Hoja de trabajo finalizada';
            $tipo_mensaje = 'success';
        } catch (PDOException $e) {
            $mensaje = 'Error al finalizar hoja de trabajo: ' . $e->getMessage();
            $tipo_mensaje = 'danger';
        }
    }
    
    // Obtener lista de hojas de trabajo
    if ($accion === 'listar') {
        $stmt = $pdo->prepare("
            SELECT ht.*, u.nombre as usuario_nombre,
                   COUNT(hta.id) as total_cuentas
            FROM hojas_trabajo ht
            LEFT JOIN usuarios u ON ht.usuario_creacion = u.id
            LEFT JOIN hoja_trabajo_ajustes hta ON ht.id = hta.hoja_trabajo_id
            WHERE ht.empresa_id = ?
            GROUP BY ht.id
            ORDER BY ht.fecha_creacion DESC
        ");
        $stmt->execute([$empresa_id]);
        $hojas_trabajo = $stmt->fetchAll();
    }
    
    // Obtener datos de hoja específica
    if ($accion === 'editar' && $hoja_id) {
        $stmt = $pdo->prepare("SELECT * FROM hojas_trabajo WHERE id = ? AND empresa_id = ?");
        $stmt->execute([$hoja_id, $empresa_id]);
        $hoja_actual = $stmt->fetch();
        
        if ($hoja_actual) {
            $stmt = $pdo->prepare("
                SELECT * FROM hoja_trabajo_ajustes 
                WHERE hoja_trabajo_id = ? 
                ORDER BY cuenta_contable
            ");
            $stmt->execute([$hoja_id]);
            $ajustes_hoja = $stmt->fetchAll();
        }
    }
    
} catch (PDOException $e) {
    die('Error de conexión: ' . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hoja de Trabajo - SISCONECTA ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .main-container {
            padding: 20px;
            max-width: 1800px;
            margin: 0 auto;
        }
        
        .header-section {
            background: linear-gradient(45deg, #2c3e50, #34495e);
            color: white;
            padding: 25px 30px;
            border-radius: 15px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        
        .header-title {
            font-size: 1.9rem;
            font-weight: 700;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .btn-header {
            background: rgba(255,255,255,0.15);
            border: 2px solid rgba(255,255,255,0.3);
            color: white;
            border-radius: 10px;
            padding: 12px 20px;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .content-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 25px;
        }
        
        .table {
            border-radius: 15px;
            overflow: hidden;
            font-size: 0.9rem;
        }
        
        .table th {
            background: linear-gradient(135deg, #34495e, #2c3e50);
            color: white;
            border: none;
            font-weight: 700;
            padding: 12px 8px;
            text-align: center;
            vertical-align: middle;
            white-space: nowrap;
        }
        
        .table td {
            padding: 10px 8px;
            vertical-align: middle;
            border-top: 1px solid #f1f3f4;
            text-align: center;
        }
        
        .table tbody tr:hover {
            background: #f8f9fa;
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 8px 10px;
            font-size: 0.9rem;
        }
        
        .form-control:focus {
            border-color: #3498db;
            box-shadow: 0 0 0 0.2rem rgba(52,152,219,0.25);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #3498db, #2980b9);
            border: none;
            border-radius: 10px;
            padding: 12px 25px;
            font-weight: 600;
        }
        
        .badge {
            padding: 8px 12px;
            border-radius: 20px;
            font-weight: 600;
        }
        
        .hoja-trabajo-header {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 25px;
            border-left: 5px solid #3498db;
        }
        
        .columna-titulo {
            writing-mode: vertical-rl;
            text-orientation: mixed;
            min-width: 80px;
            font-weight: 700;
            font-size: 0.8rem;
        }
        
        .cuenta-nombre {
            text-align: left !important;
            font-weight: 600;
            min-width: 200px;
        }
        
        .input-ajuste {
            width: 100px;
            font-size: 0.85rem;
            text-align: right;
        }
        
        .total-row {
            background: #e9ecef;
            font-weight: 700;
        }
        
        .diferencia-row {
            background: #d4edda;
            font-weight: 700;
            border-top: 3px solid #28a745;
        }
        
        .table-scroll {
            overflow-x: auto;
            max-width: 100%;
        }
        
        .cuenta-codigo {
            font-family: 'Courier New', monospace;
            font-weight: 600;
            color: #6c757d;
        }
        
        .saldo-positivo {
            color: #28a745;
            font-weight: 600;
        }
        
        .saldo-negativo {
            color: #dc3545;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Header -->
        <div class="header-section">
            <h1 class="header-title">
                <i class="fas fa-table"></i>
                Hoja de Trabajo
            </h1>
            <div class="d-flex gap-3">
                <a href="contabilidad.php" class="btn-header">
                    <i class="fas fa-calculator"></i> Contabilidad
                </a>
                <a href="dashboard.php" class="btn-header">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <?php if ($accion === 'listar'): ?>
                    <a href="?accion=crear" class="btn-header">
                        <i class="fas fa-plus"></i> Nueva Hoja
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- Mensajes -->
        <?php if (!empty($mensaje)): ?>
            <div class="alert alert-<?php echo $tipo_mensaje; ?> alert-dismissible fade show">
                <i class="fas fa-<?php echo $tipo_mensaje === 'success' ? 'check-circle' : 'exclamation-triangle'; ?>"></i>
                <?php echo htmlspecialchars($mensaje); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if ($accion === 'listar'): ?>
            <!-- Lista de Hojas de Trabajo -->
            <div class="content-card">
                <h3><i class="fas fa-list"></i> Hojas de Trabajo</h3>
                
                <?php if (empty($hojas_trabajo)): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-table fa-3x text-muted mb-3"></i>
                        <h5>No hay hojas de trabajo creadas</h5>
                        <p class="text-muted">Cree su primera hoja de trabajo para análisis contable</p>
                        <a href="?accion=crear" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Crear Primera Hoja
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Nombre</th>
                                    <th>Período</th>
                                    <th>Fecha Desde</th>
                                    <th>Fecha Hasta</th>
                                    <th>Cuentas</th>
                                    <th>Estado</th>
                                    <th>Creado Por</th>
                                    <th>Fecha Creación</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($hojas_trabajo as $hoja): ?>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($hoja['nombre']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($hoja['periodo']); ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($hoja['fecha_desde'])); ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($hoja['fecha_hasta'])); ?></td>
                                        <td><span class="badge bg-info"><?php echo $hoja['total_cuentas']; ?></span></td>
                                        <td>
                                            <span class="badge bg-<?php echo $hoja['estado'] === 'finalizada' ? 'success' : 'warning'; ?>">
                                                <?php echo ucfirst($hoja['estado']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo htmlspecialchars($hoja['usuario_nombre']); ?></td>
                                        <td><?php echo date('d/m/Y H:i', strtotime($hoja['fecha_creacion'])); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="?accion=editar&id=<?php echo $hoja['id']; ?>" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <?php if ($hoja['estado'] === 'borrador'): ?>
                                                    <a href="?finalizar=<?php echo $hoja['id']; ?>" class="btn btn-success btn-sm" 
                                                       onclick="return confirm('¿Finalizar hoja de trabajo?')">
                                                        <i class="fas fa-check"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>

        <?php elseif ($accion === 'crear'): ?>
            <!-- Crear Nueva Hoja -->
            <div class="content-card">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3><i class="fas fa-plus"></i> Nueva Hoja de Trabajo</h3>
                    <a href="?accion=listar" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Volver
                    </a>
                </div>
                
                <form method="POST">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Nombre de la Hoja *</label>
                            <input type="text" name="nombre" class="form-control" 
                                   placeholder="Ej: Hoja de Trabajo Diciembre 2024" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Período *</label>
                            <input type="text" name="periodo" class="form-control" 
                                   placeholder="Ej: 2024-12" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Fecha Desde *</label>
                            <input type="date" name="fecha_desde" class="form-control" 
                                   value="<?php echo date('Y-m-01'); ?>" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Fecha Hasta *</label>
                            <input type="date" name="fecha_hasta" class="form-control" 
                                   value="<?php echo date('Y-m-t'); ?>" required>
                        </div>
                        
                        <div class="col-12">
                            <label class="form-label">Observaciones</label>
                            <textarea name="observaciones" class="form-control" rows="3" 
                                      placeholder="Notas y observaciones sobre esta hoja de trabajo"></textarea>
                        </div>
                        
                        <div class="col-12">
                            <button type="submit" name="crear_hoja" class="btn btn-primary">
                                <i class="fas fa-save"></i> Crear Hoja de Trabajo
                            </button>
                        </div>
                    </div>
                </form>
            </div>

        <?php elseif ($accion === 'editar' && isset($hoja_actual)): ?>
            <!-- Editar Hoja de Trabajo -->
            <div class="hoja-trabajo-header">
                <div class="row">
                    <div class="col-md-8">
                        <h4><i class="fas fa-table"></i> <?php echo htmlspecialchars($hoja_actual['nombre']); ?></h4>
                        <p class="mb-0">
                            <strong>Período:</strong> <?php echo htmlspecialchars($hoja_actual['periodo']); ?> |
                            <strong>Desde:</strong> <?php echo date('d/m/Y', strtotime($hoja_actual['fecha_desde'])); ?> |
                            <strong>Hasta:</strong> <?php echo date('d/m/Y', strtotime($hoja_actual['fecha_hasta'])); ?> |
                            <span class="badge bg-<?php echo $hoja_actual['estado'] === 'finalizada' ? 'success' : 'warning'; ?>">
                                <?php echo ucfirst($hoja_actual['estado']); ?>
                            </span>
                        </p>
                    </div>
                    <div class="col-md-4 text-end">
                        <a href="?accion=listar" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver al Listado
                        </a>
                        <?php if ($hoja_actual['estado'] === 'borrador'): ?>
                            <button class="btn btn-success" onclick="finalizarHoja()">
                                <i class="fas fa-check"></i> Finalizar
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="content-card">
                <form method="POST" id="formAjustes">
                    <input type="hidden" name="ajustes_data" id="ajustesData">
                    
                    <div class="table-scroll">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th rowspan="2">Código</th>
                                    <th rowspan="2">Cuenta</th>
                                    <th colspan="2">Saldos Iniciales</th>
                                    <th colspan="2">Ajustes</th>
                                    <th colspan="2">Saldos Ajustados</th>
                                    <th colspan="2">Balance General</th>
                                    <th colspan="2">Estado Resultados</th>
                                </tr>
                                <tr>
                                    <th class="columna-titulo">Debe</th>
                                    <th class="columna-titulo">Haber</th>
                                    <th class="columna-titulo">Debe</th>
                                    <th class="columna-titulo">Haber</th>
                                    <th class="columna-titulo">Debe</th>
                                    <th class="columna-titulo">Haber</th>
                                    <th class="columna-titulo">Debe</th>
                                    <th class="columna-titulo">Haber</th>
                                    <th class="columna-titulo">Debe</th>
                                    <th class="columna-titulo">Haber</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $total_inicial_debe = 0;
                                $total_inicial_haber = 0;
                                $total_ajuste_debe = 0;
                                $total_ajuste_haber = 0;
                                $total_ajustado_debe = 0;
                                $total_ajustado_haber = 0;
                                $total_balance_debe = 0;
                                $total_balance_haber = 0;
                                $total_resultado_debe = 0;
                                $total_resultado_haber = 0;
                                
                                foreach ($ajustes_hoja as $ajuste): 
                                    $total_inicial_debe += $ajuste['saldo_inicial_debe'];
                                    $total_inicial_haber += $ajuste['saldo_inicial_haber'];
                                    $total_ajuste_debe += $ajuste['ajuste_debe'];
                                    $total_ajuste_haber += $ajuste['ajuste_haber'];
                                    $total_ajustado_debe += $ajuste['saldo_ajustado_debe'];
                                    $total_ajustado_haber += $ajuste['saldo_ajustado_haber'];
                                    $total_balance_debe += $ajuste['balance_debe'];
                                    $total_balance_haber += $ajuste['balance_haber'];
                                    $total_resultado_debe += $ajuste['resultado_debe'];
                                    $total_resultado_haber += $ajuste['resultado_haber'];
                                ?>
                                    <tr>
                                        <td class="cuenta-codigo"><?php echo htmlspecialchars($ajuste['cuenta_contable']); ?></td>
                                        <td class="cuenta-nombre"><?php echo htmlspecialchars($ajuste['nombre_cuenta']); ?></td>
                                        <td><?php echo number_format($ajuste['saldo_inicial_debe'], 2); ?></td>
                                        <td><?php echo number_format($ajuste['saldo_inicial_haber'], 2); ?></td>
                                        <td>
                                            <?php if ($hoja_actual['estado'] === 'borrador'): ?>
                                                <input type="number" class="form-control input-ajuste ajuste-debe" 
                                                       data-cuenta="<?php echo $ajuste['cuenta_contable']; ?>"
                                                       value="<?php echo $ajuste['ajuste_debe']; ?>" step="0.01">
                                            <?php else: ?>
                                                <?php echo number_format($ajuste['ajuste_debe'], 2); ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($hoja_actual['estado'] === 'borrador'): ?>
                                                <input type="number" class="form-control input-ajuste ajuste-haber" 
                                                       data-cuenta="<?php echo $ajuste['cuenta_contable']; ?>"
                                                       value="<?php echo $ajuste['ajuste_haber']; ?>" step="0.01">
                                            <?php else: ?>
                                                <?php echo number_format($ajuste['ajuste_haber'], 2); ?>
                                            <?php endif; ?>
                                        </td>
                                        <td class="saldo-ajustado-debe"><?php echo number_format($ajuste['saldo_ajustado_debe'], 2); ?></td>
                                        <td class="saldo-ajustado-haber"><?php echo number_format($ajuste['saldo_ajustado_haber'], 2); ?></td>
                                        <td><?php echo number_format($ajuste['balance_debe'], 2); ?></td>
                                        <td><?php echo number_format($ajuste['balance_haber'], 2); ?></td>
                                        <td><?php echo number_format($ajuste['resultado_debe'], 2); ?></td>
                                        <td><?php echo number_format($ajuste['resultado_haber'], 2); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                
                                <!-- Totales -->
                                <tr class="total-row">
                                    <td colspan="2"><strong>TOTALES</strong></td>
                                    <td><strong><?php echo number_format($total_inicial_debe, 2); ?></strong></td>
                                    <td><strong><?php echo number_format($total_inicial_haber, 2); ?></strong></td>
                                    <td id="total-ajuste-debe"><strong><?php echo number_format($total_ajuste_debe, 2); ?></strong></td>
                                    <td id="total-ajuste-haber"><strong><?php echo number_format($total_ajuste_haber, 2); ?></strong></td>
                                    <td id="total-ajustado-debe"><strong><?php echo number_format($total_ajustado_debe, 2); ?></strong></td>
                                    <td id="total-ajustado-haber"><strong><?php echo number_format($total_ajustado_haber, 2); ?></strong></td>
                                    <td><strong><?php echo number_format($total_balance_debe, 2); ?></strong></td>
                                    <td><strong><?php echo number_format($total_balance_haber, 2); ?></strong></td>
                                    <td><strong><?php echo number_format($total_resultado_debe, 2); ?></strong></td>
                                    <td><strong><?php echo number_format($total_resultado_haber, 2); ?></strong></td>
                                </tr>
                                
                                <!-- Diferencias -->
                                <tr class="diferencia-row">
                                    <td colspan="2"><strong>DIFERENCIAS</strong></td>
                                    <td><strong><?php echo number_format($total_inicial_debe - $total_inicial_haber, 2); ?></strong></td>
                                    <td></td>
                                    <td id="dif-ajuste"><strong><?php echo number_format($total_ajuste_debe - $total_ajuste_haber, 2); ?></strong></td>
                                    <td></td>
                                    <td id="dif-ajustado"><strong><?php echo number_format($total_ajustado_debe - $total_ajustado_haber, 2); ?></strong></td>
                                    <td></td>
                                    <td><strong><?php echo number_format($total_balance_debe - $total_balance_haber, 2); ?></strong></td>
                                    <td></td>
                                    <td><strong><?php echo number_format($total_resultado_debe - $total_resultado_haber, 2); ?></strong></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <?php if ($hoja_actual['estado'] === 'borrador'): ?>
                        <div class="text-center mt-4">
                            <button type="submit" name="guardar_ajustes" class="btn btn-primary">
                                <i class="fas fa-save"></i> Guardar Ajustes
                            </button>
                            <button type="button" class="btn btn-success" onclick="finalizarHoja()">
                                <i class="fas fa-check"></i> Finalizar Hoja de Trabajo
                            </button>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Recalcular totales al cambiar ajustes
        document.querySelectorAll('.input-ajuste').forEach(input => {
            input.addEventListener('input', function() {
                const cuenta = this.dataset.cuenta;
                const row = this.closest('tr');
                
                // Obtener valores
                const ajusteDebe = parseFloat(row.querySelector('.ajuste-debe').value) || 0;
                const ajusteHaber = parseFloat(row.querySelector('.ajuste-haber').value) || 0;
                
                // Obtener saldos iniciales
                const inicialDebe = parseFloat(row.cells[2].textContent.replace(/,/g, '')) || 0;
                const inicialHaber = parseFloat(row.cells[3].textContent.replace(/,/g, '')) || 0;
                
                // Calcular saldos ajustados
                const ajustadoDebe = inicialDebe + ajusteDebe;
                const ajustadoHaber = inicialHaber + ajusteHaber;
                
                // Actualizar celdas
                row.querySelector('.saldo-ajustado-debe').textContent = ajustadoDebe.toFixed(2);
                row.querySelector('.saldo-ajustado-haber').textContent = ajustadoHaber.toFixed(2);
                
                // Recalcular totales generales
                recalcularTotales();
            });
        });
        
        function recalcularTotales() {
            let totalAjusteDebe = 0;
            let totalAjusteHaber = 0;
            let totalAjustadoDebe = 0;
            let totalAjustadoHaber = 0;
            
            document.querySelectorAll('tbody tr:not(.total-row):not(.diferencia-row)').forEach(row => {
                const ajusteDebe = parseFloat(row.querySelector('.ajuste-debe')?.value) || 0;
                const ajusteHaber = parseFloat(row.querySelector('.ajuste-haber')?.value) || 0;
                const ajustadoDebe = parseFloat(row.querySelector('.saldo-ajustado-debe').textContent) || 0;
                const ajustadoHaber = parseFloat(row.querySelector('.saldo-ajustado-haber').textContent) || 0;
                
                totalAjusteDebe += ajusteDebe;
                totalAjusteHaber += ajusteHaber;
                totalAjustadoDebe += ajustadoDebe;
                totalAjustadoHaber += ajustadoHaber;
            });
            
            // Actualizar totales
            document.getElementById('total-ajuste-debe').innerHTML = '<strong>' + totalAjusteDebe.toFixed(2) + '</strong>';
            document.getElementById('total-ajuste-haber').innerHTML = '<strong>' + totalAjusteHaber.toFixed(2) + '</strong>';
            document.getElementById('total-ajustado-debe').innerHTML = '<strong>' + totalAjustadoDebe.toFixed(2) + '</strong>';
            document.getElementById('total-ajustado-haber').innerHTML = '<strong>' + totalAjustadoHaber.toFixed(2) + '</strong>';
            
            // Actualizar diferencias
            document.getElementById('dif-ajuste').innerHTML = '<strong>' + (totalAjusteDebe - totalAjusteHaber).toFixed(2) + '</strong>';
            document.getElementById('dif-ajustado').innerHTML = '<strong>' + (totalAjustadoDebe - totalAjustadoHaber).toFixed(2) + '</strong>';
        }
        
        // Guardar ajustes
        document.getElementById('formAjustes')?.addEventListener('submit', function(e) {
            const ajustes = [];
            
            document.querySelectorAll('tbody tr:not(.total-row):not(.diferencia-row)').forEach(row => {
                const cuenta = row.querySelector('.ajuste-debe')?.dataset?.cuenta;
                if (cuenta) {
                    const ajusteDebe = parseFloat(row.querySelector('.ajuste-debe').value) || 0;
                    const ajusteHaber = parseFloat(row.querySelector('.ajuste-haber').value) || 0;
                    
                    ajustes.push({
                        cuenta: cuenta,
                        ajuste_debe: ajusteDebe,
                        ajuste_haber: ajusteHaber
                    });
                }
            });
            
            document.getElementById('ajustesData').value = JSON.stringify(ajustes);
        });
        
        function finalizarHoja() {
            if (confirm('¿Está seguro de finalizar esta hoja de trabajo? No podrá realizar más cambios.')) {
                window.location.href = '?finalizar=<?php echo $hoja_id; ?>';
            }
        }
        
        console.log('Hoja de Trabajo - SISCONECTA ERP');
        console.log('Módulo de análisis contable y ajustes');
    </script>
</body>
</html>