<?php
// DASHBOARD PRINCIPAL - SISCONECTA ERP
// dashboard.php

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar sesión activa
if (!isset($_SESSION['user_id']) || !isset($_SESSION['empresa_id'])) {
    header('Location: login.php');
    exit;
}

// Configuración de base de datos
$host = 'localhost';
$dbname = 'conectae_sisconecta';
$username = 'conectae_sisconectauser';
$password = 'pt125824caraud';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Verificar que la empresa siga activa y no vencida
    $stmt = $pdo->prepare("SELECT * FROM empresas WHERE id = ? AND estado = 'activo'");
    $stmt->execute([$_SESSION['empresa_id']]);
    $empresa = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$empresa) {
        session_destroy();
        header('Location: login.php?error=empresa_inactiva');
        exit;
    }
    
    // Verificar vencimiento (excepto AUDITOREX CHILE)
    if ($empresa['codigo_empresa'] !== 'AUDITOREX_CHILE') {
        $fecha_actual = new DateTime();
        $fecha_vencimiento = new DateTime($empresa['fecha_vencimiento']);
        
        if ($fecha_actual > $fecha_vencimiento) {
            session_destroy();
            header('Location: login.php?error=suscripcion_vencida');
            exit;
        }
    }
    
    // Obtener estadísticas del dashboard
    $empresa_id = $_SESSION['empresa_id'];
    
    // Total de productos
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM productos WHERE empresa_id = ? AND activo = 1");
    $stmt->execute([$empresa_id]);
    $total_productos = $stmt->fetch()['total'];
    
    // Total de documentos del mes actual
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM documentos_tributarios WHERE empresa_id = ? AND MONTH(fecha_emision) = MONTH(CURDATE()) AND YEAR(fecha_emision) = YEAR(CURDATE())");
    $stmt->execute([$empresa_id]);
    $documentos_mes = $stmt->fetch()['total'];
    
    // Ventas del mes
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(total), 0) as total FROM documentos_tributarios WHERE empresa_id = ? AND tipo_documento IN ('factura', 'boleta') AND estado != 'anulado' AND MONTH(fecha_emision) = MONTH(CURDATE()) AND YEAR(fecha_emision) = YEAR(CURDATE())");
    $stmt->execute([$empresa_id]);
    $ventas_mes = $stmt->fetch()['total'];
    
    // Total de usuarios
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM usuarios WHERE empresa_id = ? AND estado = 'activo'");
    $stmt->execute([$empresa_id]);
    $total_usuarios = $stmt->fetch()['total'];
    
    // Productos con stock bajo
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM productos WHERE empresa_id = ? AND stock_actual <= stock_minimo AND activo = 1");
    $stmt->execute([$empresa_id]);
    $productos_stock_bajo = $stmt->fetch()['total'];
    
    // Documentos recientes
    $stmt = $pdo->prepare("SELECT tipo_documento, numero_documento, fecha_emision, razon_social_cliente, total, moneda, estado FROM documentos_tributarios WHERE empresa_id = ? ORDER BY fecha_registro DESC LIMIT 10");
    $stmt->execute([$empresa_id]);
    $documentos_recientes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Ventas por mes (últimos 6 meses)
    $stmt = $pdo->prepare("
        SELECT 
            DATE_FORMAT(fecha_emision, '%Y-%m') as mes,
            COALESCE(SUM(total), 0) as total_ventas
        FROM documentos_tributarios 
        WHERE empresa_id = ? 
        AND tipo_documento IN ('factura', 'boleta') 
        AND estado != 'anulado'
        AND fecha_emision >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
        GROUP BY DATE_FORMAT(fecha_emision, '%Y-%m')
        ORDER BY mes ASC
    ");
    $stmt->execute([$empresa_id]);
    $ventas_mensuales = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Saldo de cajas
    $stmt = $pdo->prepare("SELECT nombre_caja, saldo_actual, moneda, estado FROM cajas WHERE empresa_id = ?");
    $stmt->execute([$empresa_id]);
    $cajas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (PDOException $e) {
    die('Error de conexión: ' . $e->getMessage());
}

// Procesar logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - SISCONECTA ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root {
            --primary-blue: #1e40af;
            --secondary-blue: #3b82f6;
            --light-blue: #dbeafe;
            --dark-blue: #1e3a8a;
            --accent-blue: #60a5fa;
            --gradient-primary: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
            --gradient-secondary: linear-gradient(135deg, #1e3a8a 0%, #1e40af 100%);
            --shadow-primary: 0 10px 25px rgba(30, 64, 175, 0.15);
            --shadow-secondary: 0 4px 15px rgba(30, 64, 175, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            color: #334155;
        }
        
        .sidebar {
            background: var(--gradient-secondary);
            min-height: 100vh;
            width: 280px;
            position: fixed;
            left: 0;
            top: 0;
            z-index: 1000;
            transition: all 0.3s ease;
            box-shadow: 4px 0 20px rgba(30, 64, 175, 0.15);
            border-right: 1px solid rgba(59, 130, 246, 0.1);
        }
        
        .sidebar.collapsed {
            width: 80px;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            background: rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        
        .sidebar-brand {
            color: white;
            text-decoration: none;
            font-size: 1.6rem;
            font-weight: 800;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.3s ease;
        }
        
        .sidebar-brand:hover {
            color: #dbeafe;
            transform: translateX(5px);
        }
        
        .sidebar-brand i {
            font-size: 2.2rem;
            color: #60a5fa;
            filter: drop-shadow(0 0 8px rgba(96, 165, 250, 0.3));
        }
        
        .sidebar-nav {
            padding: 25px 0;
        }
        
        .nav-item {
            margin: 8px 20px;
        }
        
        .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 18px 22px;
            border-radius: 12px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.3s ease;
            font-weight: 500;
            font-size: 0.95rem;
            position: relative;
            overflow: hidden;
        }
        
        .nav-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent);
            transition: left 0.5s ease;
        }
        
        .nav-link:hover::before {
            left: 100%;
        }
        
        .nav-link:hover {
            background: rgba(255,255,255,0.15);
            color: white;
            transform: translateX(8px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        .nav-link.active {
            background: linear-gradient(135deg, #60a5fa, #3b82f6);
            color: white;
            box-shadow: 0 8px 25px rgba(96, 165, 250, 0.4);
            transform: translateX(5px);
        }
        
        .nav-link i {
            font-size: 1.3rem;
            width: 22px;
            text-align: center;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover i {
            transform: scale(1.1);
        }
        
        .main-content {
            margin-left: 280px;
            transition: all 0.3s ease;
            min-height: 100vh;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }
        
        .main-content.expanded {
            margin-left: 80px;
        }
        
        .top-navbar {
            background: white;
            padding: 25px 35px;
            box-shadow: var(--shadow-secondary);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 999;
            border-bottom: 1px solid #e2e8f0;
            backdrop-filter: blur(10px);
        }
        
        .navbar-left {
            display: flex;
            align-items: center;
            gap: 25px;
        }
        
        .sidebar-toggle {
            background: var(--gradient-primary);
            border: none;
            font-size: 1.4rem;
            color: white;
            cursor: pointer;
            padding: 12px;
            border-radius: 10px;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-secondary);
        }
        
        .sidebar-toggle:hover {
            background: var(--gradient-secondary);
            transform: translateY(-2px);
            box-shadow: var(--shadow-primary);
        }
        
        .navbar-brand {
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin: 0;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .navbar-right {
            display: flex;
            align-items: center;
            gap: 25px;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
            color: #334155;
            background: var(--light-blue);
            padding: 12px 20px;
            border-radius: 50px;
            transition: all 0.3s ease;
        }
        
        .user-info:hover {
            background: #bfdbfe;
            transform: translateY(-1px);
        }
        
        .user-avatar {
            width: 50px;
            height: 50px;
            background: var(--gradient-primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 1.3rem;
            box-shadow: var(--shadow-secondary);
            border: 3px solid white;
        }
        
        .user-details h6 {
            margin: 0;
            font-weight: 600;
            color: var(--primary-blue);
        }
        
        .user-details small {
            color: #64748b;
            font-weight: 500;
        }
        
        .content-area {
            padding: 35px;
        }
        
        .stats-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 35px;
        }
        
        .stat-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: var(--shadow-secondary);
            transition: all 0.3s ease;
            border: 1px solid rgba(226, 232, 240, 0.6);
            position: relative;
            overflow: hidden;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient-primary);
        }
        
        .stat-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-primary);
            border-color: var(--accent-blue);
        }
        
        .stat-card.primary::before { background: linear-gradient(135deg, #1e40af, #3b82f6); }
        .stat-card.success::before { background: linear-gradient(135deg, #059669, #10b981); }
        .stat-card.warning::before { background: linear-gradient(135deg, #d97706, #f59e0b); }
        .stat-card.danger::before { background: linear-gradient(135deg, #dc2626, #ef4444); }
        .stat-card.info::before { background: linear-gradient(135deg, #7c3aed, #8b5cf6); }
        
        .stat-icon {
            width: 70px;
            height: 70px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
            margin-bottom: 20px;
            box-shadow: var(--shadow-secondary);
        }
        
        .stat-card.primary .stat-icon { background: var(--gradient-primary); }
        .stat-card.success .stat-icon { background: linear-gradient(135deg, #059669, #10b981); }
        .stat-card.warning .stat-icon { background: linear-gradient(135deg, #d97706, #f59e0b); }
        .stat-card.danger .stat-icon { background: linear-gradient(135deg, #dc2626, #ef4444); }
        .stat-card.info .stat-icon { background: linear-gradient(135deg, #7c3aed, #8b5cf6); }
        
        .stat-value {
            font-size: 2.8rem;
            font-weight: 800;
            color: var(--primary-blue);
            margin-bottom: 8px;
            line-height: 1;
        }
        
        .stat-label {
            color: #64748b;
            font-weight: 600;
            margin-bottom: 12px;
            font-size: 0.95rem;
        }
        
        .stat-change {
            font-size: 0.9rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .stat-change.positive {
            color: #059669;
        }
        
        .stat-change.negative {
            color: #dc2626;
        }
        
        .dashboard-row {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 30px;
            margin-bottom: 35px;
        }
        
        .dashboard-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: var(--shadow-secondary);
            border: 1px solid rgba(226, 232, 240, 0.6);
            transition: all 0.3s ease;
        }
        
        .dashboard-card:hover {
            box-shadow: var(--shadow-primary);
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 20px;
            border-bottom: 2px solid #f1f5f9;
        }
        
        .card-title {
            font-size: 1.4rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .table-responsive {
            margin-top: 20px;
            border-radius: 12px;
            overflow: hidden;
        }
        
        .table {
            margin: 0;
            background: white;
        }
        
        .table th {
            border-top: none;
            border-bottom: 2px solid #e2e8f0;
            font-weight: 700;
            color: var(--primary-blue);
            padding: 18px 15px;
            background: #f8fafc;
        }
        
        .table td {
            padding: 18px 15px;
            vertical-align: middle;
            border-top: 1px solid #f1f5f9;
        }
        
        .table tbody tr:hover {
            background: #f8fafc;
            transform: scale(1.01);
            transition: all 0.2s ease;
        }
        
        .badge {
            padding: 8px 14px;
            border-radius: 25px;
            font-weight: 600;
            font-size: 0.8rem;
            border: 1px solid transparent;
        }
        
        .badge.bg-success {
            background: linear-gradient(135deg, #059669, #10b981) !important;
            box-shadow: 0 3px 10px rgba(5, 150, 105, 0.3);
        }
        
        .badge.bg-warning {
            background: linear-gradient(135deg, #d97706, #f59e0b) !important;
            box-shadow: 0 3px 10px rgba(217, 119, 6, 0.3);
        }
        
        .badge.bg-danger {
            background: linear-gradient(135deg, #dc2626, #ef4444) !important;
            box-shadow: 0 3px 10px rgba(220, 38, 38, 0.3);
        }
        
        .badge.bg-primary {
            background: var(--gradient-primary) !important;
            box-shadow: 0 3px 10px rgba(30, 64, 175, 0.3);
        }
        
        .caja-item {
            background: var(--light-blue);
            padding: 20px;
            border-radius: 16px;
            margin-bottom: 20px;
            border-left: 5px solid var(--primary-blue);
            transition: all 0.3s ease;
        }
        
        .caja-item:hover {
            background: #bfdbfe;
            transform: translateX(5px);
            box-shadow: var(--shadow-secondary);
        }
        
        .caja-name {
            font-weight: 700;
            color: var(--primary-blue);
            margin-bottom: 8px;
            font-size: 1.1rem;
        }
        
        .caja-balance {
            font-size: 1.4rem;
            font-weight: 800;
            color: #059669;
            margin-bottom: 5px;
        }
        
        .caja-status {
            font-size: 0.9rem;
            color: #64748b;
        }
        
        .btn-logout {
            background: linear-gradient(135deg, #dc2626, #ef4444);
            border: none;
            border-radius: 12px;
            padding: 12px 24px;
            color: white;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-secondary);
        }
        
        .btn-logout:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(220, 38, 38, 0.4);
            background: linear-gradient(135deg, #b91c1c, #dc2626);
        }
        
        .empresa-info {
            background: var(--gradient-primary);
            color: white;
            padding: 25px 30px;
            border-radius: 20px;
            margin-bottom: 35px;
            box-shadow: var(--shadow-primary);
            position: relative;
            overflow: hidden;
        }
        
        .empresa-info::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 30px 30px;
            animation: float 20s linear infinite;
        }
        
        @keyframes float {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .empresa-info h4 {
            margin: 0 0 12px 0;
            font-weight: 700;
            font-size: 1.6rem;
            position: relative;
            z-index: 2;
        }
        
        .empresa-info p {
            margin: 0;
            opacity: 0.9;
            font-weight: 500;
            position: relative;
            z-index: 2;
        }
        
        .chart-container {
            position: relative;
            height: 320px;
            margin-top: 25px;
        }
        
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .quick-action-btn {
            background: white;
            border: 2px solid var(--light-blue);
            border-radius: 16px;
            padding: 20px;
            text-decoration: none;
            color: var(--primary-blue);
            text-align: center;
            transition: all 0.3s ease;
            font-weight: 600;
            box-shadow: var(--shadow-secondary);
        }
        
        .quick-action-btn:hover {
            background: var(--gradient-primary);
            color: white;
            transform: translateY(-5px);
            box-shadow: var(--shadow-primary);
            border-color: var(--primary-blue);
        }
        
        .quick-action-btn i {
            font-size: 2rem;
            margin-bottom: 10px;
            display: block;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .dashboard-row {
                grid-template-columns: 1fr;
            }
            
            .stats-cards {
                grid-template-columns: 1fr;
            }
            
            .content-area {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <a href="dashboard.php" class="sidebar-brand">
                <i class="fas fa-chart-line"></i>
                <span class="brand-text">SISCONECTA</span>
            </a>
        </div>
        
        <nav class="sidebar-nav">
            <div class="nav-item">
                <a href="dashboard.php" class="nav-link active">
                    <i class="fas fa-tachometer-alt"></i>
                    <span class="nav-text">Dashboard</span>
                </a>
            </div>
            
            <div class="nav-item">
                <a href="pos.php" class="nav-link">
                    <i class="fas fa-shopping-cart"></i>
                    <span class="nav-text">Punto de Venta</span>
                </a>
            </div>
            
            <div class="nav-item">
                <a href="productos.php" class="nav-link">
                    <i class="fas fa-boxes"></i>
                    <span class="nav-text">Productos</span>
                </a>
            </div>
            
            <div class="nav-item">
                <a href="facturacion.php" class="nav-link">
                    <i class="fas fa-file-invoice"></i>
                    <span class="nav-text">Facturación</span>
                </a>
            </div>
            
          
<a href="contabilidad.php" class="nav-link">
    <i class="fas fa-calculator"></i>
    <span class="nav-text">Contabilidad</span>
</a>

<div class="nav-item">
    <a href="cuentas_por_cobrar.php" class="nav-link">
        <i class="fas fa-coins"></i>
        <span class="nav-text">Por Cobrar</span>
    </a>
</div>

<div class="nav-item">
    <a href="cuentas_por_pagar.php" class="nav-link">
        <i class="fas fa-credit-card"></i>
        <span class="nav-text">Por Pagar</span>
    </a>
</div>

<div class="nav-item">
    <a href="hoja_trabajo.php" class="nav-link">
        <i class="fas fa-clipboard-list"></i>
        <span class="nav-text">Hoja de Trabajo</span>
    </a>
</div>

<div class="nav-item">
    <a href="cotizaciones.php" class="nav-link">
        <i class="fas fa-file-invoice-dollar"></i>
        <span class="nav-text">Cotizaciones</span>
    </a>
</div>

<div class="nav-item">
    <a href="fidelizacion.php" class="nav-link">
        <i class="fas fa-gift"></i>
        <span class="nav-text">Fidelización</span>
    </a>
</div>

<a href="reportes.php" class="nav-link">
    <i class="fas fa-chart-bar"></i>
    <span class="nav-text">Reportes</span>
</a>

<a href="configuracion.php" class="nav-link">
    <i class="fas fa-cog"></i>
    <span class="nav-text">Configuración</span>
</a>
            </div>
        </nav>
    </div>
    
    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <!-- Top Navbar -->
        <div class="top-navbar">
            <div class="navbar-left">
                <button class="sidebar-toggle" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1 class="navbar-brand">Dashboard Principal</h1>
            </div>
            
            <div class="navbar-right">
                <div class="user-info">
                    <div class="user-avatar">
                        <?php echo strtoupper(substr($_SESSION['nombre'], 0, 1)); ?>
                    </div>
                    <div class="user-details">
                        <h6><?php echo htmlspecialchars($_SESSION['nombre']); ?></h6>
                        <small><?php echo htmlspecialchars($_SESSION['rol']); ?> - <?php echo htmlspecialchars($_SESSION['empresa_razon_social']); ?></small>
                    </div>
                </div>
                <a href="?logout=1" class="btn btn-logout">
                    <i class="fas fa-sign-out-alt"></i> Salir
                </a>
            </div>
        </div>
        
        <!-- Content Area -->
        <div class="content-area">
            <!-- Información de la Empresa -->
            <div class="empresa-info">
                <h4><?php echo htmlspecialchars($empresa['razon_social']); ?></h4>
                <p>RUT: <?php echo htmlspecialchars($empresa['rut']); ?> | Código: <?php echo htmlspecialchars($empresa['codigo_empresa']); ?> | 
                <?php if ($empresa['codigo_empresa'] === 'AUDITOREX_CHILE'): ?>
                    <span class="badge bg-light text-dark">Acceso Libre Permanente</span>
                <?php else: ?>
                    Vence: <?php echo date('d/m/Y', strtotime($empresa['fecha_vencimiento'])); ?>
                <?php endif; ?>
                </p>
            </div>
            
            <!-- Quick Actions -->
            <div class="quick-actions">
                <a href="pos.php" class="quick-action-btn">
                    <i class="fas fa-shopping-cart"></i>
                    Punto de Venta
                </a>
                <a href="productos.php" class="quick-action-btn">
                    <i class="fas fa-boxes"></i>
                    Gestión Productos
                </a>
                <a href="facturacion.php" class="quick-action-btn">
                    <i class="fas fa-file-invoice"></i>
                    Facturación DTE
                </a>
                <a href="#" class="quick-action-btn" onclick="alert('Módulo en desarrollo')">
                    <i class="fas fa-chart-bar"></i>
                    Reportes
                </a>
            </div>
            
            <!-- Statistics Cards -->
            <div class="stats-cards">
                <div class="stat-card primary">
                    <div class="stat-icon">
                        <i class="fas fa-boxes"></i>
                    </div>
                    <div class="stat-value"><?php echo number_format($total_productos); ?></div>
                    <div class="stat-label">Productos Registrados</div>
                    <div class="stat-change positive">
                        <i class="fas fa-arrow-up"></i> Activos en sistema
                    </div>
                </div>
                
                <div class="stat-card success">
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="stat-value">$<?php echo number_format($ventas_mes, 0, ',', '.'); ?></div>
                    <div class="stat-label">Ventas del Mes</div>
                    <div class="stat-change positive">
                        <i class="fas fa-arrow-up"></i> <?php echo $empresa['moneda_principal']; ?>
                    </div>
                </div>
                
                <div class="stat-card warning">
                    <div class="stat-icon">
                        <i class="fas fa-file-invoice"></i>
                    </div>
                    <div class="stat-value"><?php echo number_format($documentos_mes); ?></div>
                    <div class="stat-label">Documentos del Mes</div>
                    <div class="stat-change positive">
                        <i class="fas fa-chart-line"></i> Emitidos
                    </div>
                </div>
                
                <div class="stat-card danger">
                    <div class="stat-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="stat-value"><?php echo number_format($productos_stock_bajo); ?></div>
                    <div class="stat-label">Stock Bajo</div>
                    <div class="stat-change <?php echo $productos_stock_bajo > 0 ? 'negative' : 'positive'; ?>">
                        <i class="fas fa-<?php echo $productos_stock_bajo > 0 ? 'arrow-down' : 'check'; ?>"></i> Productos
                    </div>
                </div>
                
                <div class="stat-card info">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-value"><?php echo number_format($total_usuarios); ?></div>
                    <div class="stat-label">Usuarios Activos</div>
                    <div class="stat-change positive">
                        <i class="fas fa-user-check"></i> En sistema
                    </div>
                </div>
            </div>
            
            <!-- Dashboard Content Row -->
            <div class="dashboard-row">
                <!-- Ventas Chart -->
                <div class="dashboard-card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-chart-line"></i> Ventas Mensuales
                        </h3>
                    </div>
                    <div class="chart-container">
                        <canvas id="ventasChart"></canvas>
                    </div>
                </div>
                
                <!-- Cajas -->
                <div class="dashboard-card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-cash-register"></i> Estado de Cajas
                        </h3>
                    </div>
                    <?php if (empty($cajas)): ?>
                        <div class="text-center text-muted">
                            <i class="fas fa-cash-register fa-3x mb-3 opacity-25"></i>
                            <p>No hay cajas configuradas</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($cajas as $caja): ?>
                            <div class="caja-item">
                                <div class="caja-name"><?php echo htmlspecialchars($caja['nombre_caja']); ?></div>
                                <div class="caja-balance">
                                    <?php echo $caja['moneda']; ?> <?php echo number_format($caja['saldo_actual'], 2, ',', '.'); ?>
                                </div>
                                <div class="caja-status">
                                    <span class="badge <?php echo $caja['estado'] === 'abierta' ? 'bg-success' : 'bg-warning'; ?>">
                                        <?php echo ucfirst($caja['estado']); ?>
                                    </span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Recent Documents -->
            <div class="dashboard-card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-file-alt"></i> Documentos Recientes
                    </h3>
                </div>
                
                <?php if (empty($documentos_recientes)): ?>
                    <div class="text-center text-muted">
                        <i class="fas fa-file-alt fa-3x mb-3 opacity-25"></i>
                        <p>No hay documentos registrados</p>
                        <a href="pos.php" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Crear Primera Venta
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Tipo</th>
                                    <th>Número</th>
                                    <th>Fecha</th>
                                    <th>Cliente</th>
                                    <th>Total</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($documentos_recientes as $doc): ?>
                                    <tr>
                                        <td>
                                            <span class="badge bg-primary">
                                                <?php echo ucfirst(str_replace('_', ' ', $doc['tipo_documento'])); ?>
                                            </span>
                                        </td>
                                        <td><?php echo htmlspecialchars($doc['numero_documento']); ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($doc['fecha_emision'])); ?></td>
                                        <td><?php echo htmlspecialchars($doc['razon_social_cliente']); ?></td>
                                        <td><?php echo $doc['moneda']; ?> <?php echo number_format($doc['total'], 0, ',', '.'); ?></td>
                                        <td>
                                            <span class="badge bg-<?php 
                                                switch($doc['estado']) {
                                                    case 'emitido': echo 'success'; break;
                                                    case 'pagado': echo 'primary'; break;
                                                    case 'anulado': echo 'danger'; break;
                                                    default: echo 'warning'; break;
                                                }
                                            ?>">
                                                <?php echo ucfirst($doc['estado']); ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Sidebar Toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            
            sidebar.classList.toggle('collapsed');
            mainContent.classList.toggle('expanded');
        });
        
        // Initialize Chart
        const ctx = document.getElementById('ventasChart').getContext('2d');
        const ventasData = <?php echo json_encode($ventas_mensuales); ?>;
        
        const chart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ventasData.map(item => {
                    const [year, month] = item.mes.split('-');
                    const monthNames = ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'];
                    return monthNames[parseInt(month) - 1] + ' ' + year;
                }),
                datasets: [{
                    label: 'Ventas (<?php echo $empresa['moneda_principal']; ?>)',
                    data: ventasData.map(item => parseFloat(item.total_ventas)),
                    borderColor: '#1e40af',
                    backgroundColor: 'rgba(30, 64, 175, 0.1)',
                    borderWidth: 4,
                    fill: true,
                    tension: 0.4,
                    pointBackgroundColor: '#1e40af',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 3,
                    pointRadius: 8,
                    pointHoverRadius: 10,
                    pointHoverBackgroundColor: '#3b82f6',
                    pointHoverBorderColor: '#fff',
                    pointHoverBorderWidth: 3
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: 'rgba(30, 64, 175, 0.9)',
                        titleColor: '#fff',
                        bodyColor: '#fff',
                        borderColor: '#3b82f6',
                        borderWidth: 2,
                        cornerRadius: 12,
                        titleFont: {
                            size: 14,
                            weight: 'bold'
                        },
                        bodyFont: {
                            size: 13
                        },
                        callbacks: {
                            label: function(context) {
                                return 'Ventas: <?php echo $empresa['moneda_principal']; ?>' + context.parsed.y.toLocaleString();
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(30, 64, 175, 0.1)',
                            drawBorder: false
                        },
                        ticks: {
                            color: '#64748b',
                            font: {
                                size: 12,
                                weight: '500'
                            },
                            callback: function(value) {
                                return '<?php echo $empresa['moneda_principal']; ?>' + value.toLocaleString();
                            }
                        }
                    },
                    x: {
                        grid: {
                            color: 'rgba(30, 64, 175, 0.1)',
                            drawBorder: false
                        },
                        ticks: {
                            color: '#64748b',
                            font: {
                                size: 12,
                                weight: '500'
                            }
                        }
                    }
                },
                elements: {
                    line: {
                        borderCapStyle: 'round',
                        borderJoinStyle: 'round'
                    }
                }
            }
        });
        
        // Mobile responsiveness
        if (window.innerWidth <= 768) {
            document.getElementById('sidebar').classList.add('collapsed');
            document.getElementById('mainContent').classList.add('expanded');
        }
        
        // Active navigation
        document.querySelectorAll('.nav-link').forEach(link => {
            if (link.href === window.location.href) {
                link.classList.add('active');
            }
        });
        
        // Smooth transitions
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.stat-card');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                setTimeout(() => {
                    card.style.transition = 'all 0.6s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 100);
            });
        });
    </script>
</body>
</html>