<?php
// INSTALADOR DEL SISTEMA DE GESTIÓN EMPRESARIAL CHILE - CORREGIDO
// install.php

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configuración de base de datos
$host = 'localhost';
$dbname = 'conectae_sisconecta';
$username = 'conectae_sisconectauser';
$password = 'pt125824caraud';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalador - Sistema de Gestión Empresarial Chile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .install-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
            margin-top: 50px;
            padding: 40px;
        }
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo h1 {
            color: #2c3e50;
            font-weight: 700;
            margin: 0;
        }
        .progress-step {
            background: #e9ecef;
            border-radius: 10px;
            padding: 20px;
            margin: 20px 0;
        }
        .success {
            background: #d4edda;
            border-left: 5px solid #28a745;
        }
        .error {
            background: #f8d7da;
            border-left: 5px solid #dc3545;
        }
        .btn-install {
            background: linear-gradient(45deg, #28a745, #20c997);
            border: none;
            border-radius: 10px;
            padding: 15px 30px;
            font-weight: 600;
            color: white;
            transition: all 0.3s ease;
        }
        .btn-install:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="install-container">
                    <div class="logo">
                        <i class="fas fa-building fa-3x text-primary mb-3"></i>
                        <h1>Sistema de Gestión Empresarial</h1>
                        <p class="text-muted">Instalador - Versión Chile 2025</p>
                    </div>

                    <?php
                    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['install'])) {
                        try {
                            // Conexión a MySQL
                            $pdo = new PDO("mysql:host=$host;charset=utf8mb4", $username, $password);
                            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                            
                            echo '<div class="progress-step success">';
                            echo '<i class="fas fa-check-circle text-success"></i> Conexión a MySQL establecida correctamente';
                            echo '</div>';

                            // Crear base de datos si no existe
                            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci");
                            $pdo->exec("USE `$dbname`");
                            
                            echo '<div class="progress-step success">';
                            echo '<i class="fas fa-database text-success"></i> Base de datos creada/verificada correctamente';
                            echo '</div>';

                            // Crear tabla de empresas (aislamiento multiempresa)
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS empresas (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    codigo_empresa VARCHAR(50) UNIQUE NOT NULL,
                                    razon_social VARCHAR(255) NOT NULL,
                                    rut VARCHAR(20) NOT NULL,
                                    direccion TEXT,
                                    comuna VARCHAR(100),
                                    ciudad VARCHAR(100),
                                    region VARCHAR(100),
                                    telefono VARCHAR(50),
                                    email VARCHAR(100),
                                    giro VARCHAR(255),
                                    actividad_economica VARCHAR(10) DEFAULT '749000',
                                    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    estado ENUM('activo', 'suspendido', 'bloqueado') DEFAULT 'activo',
                                    fecha_vencimiento DATE,
                                    monto_suscripcion DECIMAL(10,2) DEFAULT 180.00,
                                    moneda_principal VARCHAR(3) DEFAULT 'CLP',
                                    logo TEXT,
                                    configuracion JSON,
                                    KEY idx_empresa_codigo (codigo_empresa),
                                    KEY idx_estado (estado),
                                    KEY idx_fecha_vencimiento (fecha_vencimiento)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de usuarios
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS usuarios (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT,
                                    username VARCHAR(50) NOT NULL,
                                    password VARCHAR(255) NOT NULL,
                                    nombre VARCHAR(100) NOT NULL,
                                    email VARCHAR(100) NOT NULL,
                                    rol ENUM('admin', 'contador', 'vendedor', 'auditor') DEFAULT 'admin',
                                    estado ENUM('activo', 'inactivo') DEFAULT 'activo',
                                    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    ultimo_acceso TIMESTAMP NULL,
                                    permisos JSON,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    UNIQUE KEY unique_user_empresa (username, empresa_id),
                                    KEY idx_usuario_empresa (empresa_id, username),
                                    KEY idx_estado_usuario (estado)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de monedas
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS monedas (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT,
                                    codigo VARCHAR(3) NOT NULL,
                                    nombre VARCHAR(50) NOT NULL,
                                    simbolo VARCHAR(5) NOT NULL,
                                    tasa_cambio DECIMAL(15,6) DEFAULT 1.000000,
                                    fecha_actualizacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                    activo BOOLEAN DEFAULT TRUE,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    KEY idx_moneda_empresa (empresa_id, codigo),
                                    KEY idx_activo_moneda (activo)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de productos/servicios
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS productos (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT,
                                    codigo VARCHAR(50) NOT NULL,
                                    nombre VARCHAR(255) NOT NULL,
                                    descripcion TEXT,
                                    precio_compra DECIMAL(15,2),
                                    precio_venta DECIMAL(15,2),
                                    stock_actual INT DEFAULT 0,
                                    stock_minimo INT DEFAULT 0,
                                    unidad_medida VARCHAR(10) DEFAULT 'UN',
                                    categoria VARCHAR(100),
                                    iva_porcentaje DECIMAL(5,2) DEFAULT 19.00,
                                    codigo_sii VARCHAR(20),
                                    activo BOOLEAN DEFAULT TRUE,
                                    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    UNIQUE KEY unique_codigo_empresa (codigo, empresa_id),
                                    KEY idx_producto_empresa (empresa_id, codigo),
                                    KEY idx_activo_producto (activo),
                                    KEY idx_categoria (categoria)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de documentos tributarios con TODOS los tipos del SII
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS documentos_tributarios (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT,
                                    tipo_documento VARCHAR(50) NOT NULL,
                                    codigo_sii INT NOT NULL,
                                    numero_documento VARCHAR(50) NOT NULL,
                                    folio INT NOT NULL,
                                    fecha_emision DATE NOT NULL,
                                    fecha_vencimiento DATE NULL,
                                    rut_cliente VARCHAR(20) NOT NULL,
                                    razon_social_cliente VARCHAR(255) NOT NULL,
                                    direccion_cliente TEXT,
                                    giro_cliente VARCHAR(255),
                                    comuna_cliente VARCHAR(100),
                                    ciudad_cliente VARCHAR(100),
                                    email_cliente VARCHAR(100),
                                    telefono_cliente VARCHAR(50),
                                    subtotal DECIMAL(15,2) DEFAULT 0.00,
                                    total_exento DECIMAL(15,2) DEFAULT 0.00,
                                    iva DECIMAL(15,2) DEFAULT 0.00,
                                    total DECIMAL(15,2) NOT NULL,
                                    moneda VARCHAR(3) DEFAULT 'CLP',
                                    condiciones_pago VARCHAR(100),
                                    medio_pago VARCHAR(50),
                                    estado VARCHAR(20) DEFAULT 'borrador',
                                    observaciones TEXT,
                                    xml_dte LONGTEXT,
                                    timbre_electronico TEXT,
                                    track_id VARCHAR(50),
                                    fecha_envio_sii DATETIME NULL,
                                    fecha_acuse_sii DATETIME NULL,
                                    errores_sii TEXT,
                                    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    fecha_actualizacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    UNIQUE KEY unique_folio_tipo_empresa (folio, tipo_documento, empresa_id),
                                    KEY idx_documento_empresa (empresa_id, tipo_documento),
                                    KEY idx_fecha_emision (fecha_emision),
                                    KEY idx_rut_cliente (rut_cliente),
                                    KEY idx_estado_doc (estado),
                                    KEY idx_codigo_sii (codigo_sii)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de detalles de documentos
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS documento_detalles (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    documento_id INT,
                                    producto_id INT,
                                    descripcion VARCHAR(255) NOT NULL,
                                    cantidad DECIMAL(10,3) NOT NULL,
                                    precio_unitario DECIMAL(15,2) NOT NULL,
                                    subtotal DECIMAL(15,2) NOT NULL,
                                    porcentaje_iva DECIMAL(5,2) DEFAULT 19.00,
                                    iva_item DECIMAL(15,2) DEFAULT 0.00,
                                    total_item DECIMAL(15,2) NOT NULL,
                                    descuento_porcentaje DECIMAL(5,2) DEFAULT 0.00,
                                    descuento_monto DECIMAL(15,2) DEFAULT 0.00,
                                    FOREIGN KEY (documento_id) REFERENCES documentos_tributarios(id) ON DELETE CASCADE,
                                    KEY idx_documento_detalle (documento_id),
                                    KEY idx_producto_detalle (producto_id)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de configuración DTE
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS configuracion_dte (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT NOT NULL,
                                    certificado_digital LONGTEXT,
                                    password_certificado VARCHAR(255),
                                    ambiente ENUM('certificacion', 'produccion') DEFAULT 'certificacion',
                                    resolucion_sii VARCHAR(50),
                                    fecha_resolucion DATE,
                                    actividad_economica VARCHAR(10) DEFAULT '749000',
                                    codigo_sucursal VARCHAR(10) DEFAULT '1',
                                    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    fecha_actualizacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                    UNIQUE KEY unique_empresa_dte (empresa_id),
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de folios CAF
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS folios_caf (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT NOT NULL,
                                    tipo_documento VARCHAR(50) NOT NULL,
                                    codigo_sii INT NOT NULL,
                                    folio_desde INT NOT NULL,
                                    folio_hasta INT NOT NULL,
                                    folio_actual INT NOT NULL,
                                    caf_xml LONGTEXT NOT NULL,
                                    fecha_autorizacion DATE NOT NULL,
                                    fecha_vencimiento DATE NOT NULL,
                                    estado ENUM('activo', 'agotado', 'vencido') DEFAULT 'activo',
                                    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    KEY idx_empresa_tipo_estado (empresa_id, tipo_documento, estado),
                                    KEY idx_folios_rango (folio_actual, folio_hasta),
                                    KEY idx_vencimiento_caf (fecha_vencimiento)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de contabilidad
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS asientos_contables (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT,
                                    numero_asiento INT NOT NULL,
                                    fecha DATE NOT NULL,
                                    descripcion TEXT NOT NULL,
                                    documento_referencia VARCHAR(50),
                                    tipo_asiento ENUM('manual', 'automatico') DEFAULT 'manual',
                                    estado ENUM('borrador', 'contabilizado') DEFAULT 'borrador',
                                    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    usuario_registro INT,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    FOREIGN KEY (usuario_registro) REFERENCES usuarios(id),
                                    KEY idx_asiento_empresa (empresa_id, numero_asiento),
                                    KEY idx_fecha_asiento (fecha),
                                    KEY idx_estado_asiento (estado)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de movimientos contables
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS movimientos_contables (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    asiento_id INT,
                                    cuenta_contable VARCHAR(20) NOT NULL,
                                    nombre_cuenta VARCHAR(255) NOT NULL,
                                    debe DECIMAL(15,2) DEFAULT 0.00,
                                    haber DECIMAL(15,2) DEFAULT 0.00,
                                    observaciones TEXT,
                                    FOREIGN KEY (asiento_id) REFERENCES asientos_contables(id) ON DELETE CASCADE,
                                    KEY idx_cuenta_movimiento (cuenta_contable),
                                    KEY idx_asiento_movimiento (asiento_id)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de plan de cuentas
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS plan_cuentas (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT,
                                    codigo_cuenta VARCHAR(20) NOT NULL,
                                    nombre_cuenta VARCHAR(255) NOT NULL,
                                    tipo_cuenta ENUM('activo', 'pasivo', 'patrimonio', 'ingreso', 'gasto') NOT NULL,
                                    cuenta_padre VARCHAR(20),
                                    nivel INT DEFAULT 1,
                                    activo BOOLEAN DEFAULT TRUE,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    UNIQUE KEY unique_cuenta_empresa (codigo_cuenta, empresa_id),
                                    KEY idx_tipo_cuenta (tipo_cuenta),
                                    KEY idx_cuenta_padre (cuenta_padre)
                                ) ENGINE=InnoDB
                            ");

                            // Crear tabla de configuración de cajas
                            $pdo->exec("
                                CREATE TABLE IF NOT EXISTS cajas (
                                    id INT AUTO_INCREMENT PRIMARY KEY,
                                    empresa_id INT,
                                    nombre_caja VARCHAR(100) NOT NULL,
                                    codigo_caja VARCHAR(20) NOT NULL,
                                    saldo_inicial DECIMAL(15,2) DEFAULT 0.00,
                                    saldo_actual DECIMAL(15,2) DEFAULT 0.00,
                                    moneda VARCHAR(3) DEFAULT 'CLP',
                                    estado ENUM('abierta', 'cerrada') DEFAULT 'abierta',
                                    fecha_apertura TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                                    fecha_cierre TIMESTAMP NULL,
                                    usuario_responsable INT,
                                    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
                                    FOREIGN KEY (usuario_responsable) REFERENCES usuarios(id),
                                    KEY idx_caja_empresa (empresa_id, codigo_caja),
                                    KEY idx_estado_caja (estado)
                                ) ENGINE=InnoDB
                            ");

                            echo '<div class="progress-step success">';
                            echo '<i class="fas fa-check-circle text-success"></i> Todas las tablas creadas correctamente';
                            echo '</div>';

                            // Insertar datos iniciales básicos
                            try {
                                // Monedas principales chilenas
                                $pdo->exec("
                                    INSERT IGNORE INTO monedas (empresa_id, codigo, nombre, simbolo, tasa_cambio, activo) VALUES
                                    (NULL, 'CLP', 'Peso Chileno', '$', 1.000000, TRUE),
                                    (NULL, 'USD', 'Dólar Estadounidense', 'US$', 950.000000, TRUE),
                                    (NULL, 'EUR', 'Euro', '€', 1050.000000, TRUE),
                                    (NULL, 'UF', 'Unidad de Fomento', 'UF', 37500.000000, TRUE)
                                ");

                                // Plan de cuentas básico chileno
                                $plan_cuentas = [
                                    ['1', 'ACTIVOS', 'activo', '', 1],
                                    ['11', 'ACTIVOS CORRIENTES', 'activo', '1', 2],
                                    ['1101', 'DISPONIBLE', 'activo', '11', 3],
                                    ['110101', 'CAJA', 'activo', '1101', 4],
                                    ['110102', 'BANCOS', 'activo', '1101', 4],
                                    ['1102', 'DEUDORES', 'activo', '11', 3],
                                    ['110201', 'CLIENTES', 'activo', '1102', 4],
                                    ['110202', 'DOCUMENTOS POR COBRAR', 'activo', '1102', 4],
                                    ['1103', 'EXISTENCIAS', 'activo', '11', 3],
                                    ['110301', 'MERCADERIAS', 'activo', '1103', 4],
                                    ['2', 'PASIVOS', 'pasivo', '', 1],
                                    ['21', 'PASIVOS CORRIENTES', 'pasivo', '2', 2],
                                    ['2101', 'ACREEDORES', 'pasivo', '21', 3],
                                    ['210101', 'PROVEEDORES', 'pasivo', '2101', 4],
                                    ['2102', 'OBLIGACIONES TRIBUTARIAS', 'pasivo', '21', 3],
                                    ['210201', 'IVA DEBITO FISCAL', 'pasivo', '2102', 4],
                                    ['210202', 'IVA CREDITO FISCAL', 'pasivo', '2102', 4],
                                    ['3', 'PATRIMONIO', 'patrimonio', '', 1],
                                    ['31', 'CAPITAL', 'patrimonio', '3', 2],
                                    ['3101', 'CAPITAL INICIAL', 'patrimonio', '31', 3],
                                    ['4', 'INGRESOS', 'ingreso', '', 1],
                                    ['41', 'INGRESOS OPERACIONALES', 'ingreso', '4', 2],
                                    ['4101', 'VENTAS', 'ingreso', '41', 3],
                                    ['5', 'GASTOS', 'gasto', '', 1],
                                    ['51', 'GASTOS OPERACIONALES', 'gasto', '5', 2],
                                    ['5101', 'COSTO DE VENTAS', 'gasto', '51', 3],
                                    ['5102', 'GASTOS ADMINISTRACION', 'gasto', '51', 3]
                                ];

                                foreach ($plan_cuentas as $cuenta) {
                                    $pdo->prepare("
                                        INSERT IGNORE INTO plan_cuentas (empresa_id, codigo_cuenta, nombre_cuenta, tipo_cuenta, cuenta_padre, nivel) 
                                        VALUES (NULL, ?, ?, ?, ?, ?)
                                    ")->execute($cuenta);
                                }

                                echo '<div class="progress-step success">';
                                echo '<i class="fas fa-check-circle text-success"></i> Datos iniciales insertados (monedas y plan de cuentas básico)';
                                echo '</div>';

                            } catch (Exception $e) {
                                echo '<div class="progress-step">';
                                echo '<i class="fas fa-info-circle text-info"></i> Datos iniciales omitidos (ya existen): ' . $e->getMessage();
                                echo '</div>';
                            }

                            echo '<div class="alert alert-success mt-4">';
                            echo '<h4><i class="fas fa-check-circle"></i> ¡Instalación Completada Exitosamente!</h4>';
                            echo '<p><strong>Base de datos:</strong> ' . $dbname . '</p>';
                            echo '<p><strong>Tablas creadas:</strong> Empresas, Usuarios, Productos, Documentos Tributarios, Contabilidad, DTE, CAF, etc.</p>';
                            echo '<p><strong>Características:</strong></p>';
                            echo '<ul>';
                            echo '<li>✅ Sistema multiempresa con aislamiento de datos</li>';
                            echo '<li>✅ Facturación electrónica SII Chile (todos los documentos)</li>';
                            echo '<li>✅ Contabilidad completa con plan de cuentas chileno</li>';
                            echo '<li>✅ Sistema de folios CAF del SII</li>';
                            echo '<li>✅ Punto de venta con inventario</li>';
                            echo '<li>✅ Sistema multimoneda (CLP, USD, EUR, UF)</li>';
                            echo '</ul>';
                            echo '<p class="mb-0">El sistema está listo para usar. Inserte una empresa de prueba y usuario admin para comenzar.</p>';
                            echo '</div>';

                            echo '<div class="alert alert-info">';
                            echo '<h5>📋 Próximos pasos:</h5>';
                            echo '<ol>';
                            echo '<li>Crear empresa de prueba en la base de datos</li>';
                            echo '<li>Crear usuario administrador</li>';
                            echo '<li>Configurar certificado digital para DTE</li>';
                            echo '<li>Subir archivos CAF del SII</li>';
                            echo '<li>Comenzar a facturar</li>';
                            echo '</ol>';
                            echo '</div>';

                            echo '<div class="text-center mt-4">';
                            echo '<a href="facturacion_electronica.php" class="btn btn-primary btn-lg me-3">';
                            echo '<i class="fas fa-file-invoice"></i> Ir a Facturación';
                            echo '</a>';
                            echo '<a href="configuracion_dte.php" class="btn btn-secondary btn-lg">';
                            echo '<i class="fas fa-cog"></i> Configurar DTE';
                            echo '</a>';
                            echo '</div>';

                        } catch (PDOException $e) {
                            echo '<div class="progress-step error">';
                            echo '<i class="fas fa-exclamation-triangle text-danger"></i> Error de base de datos: ' . htmlspecialchars($e->getMessage());
                            echo '</div>';
                        } catch (Exception $e) {
                            echo '<div class="progress-step error">';
                            echo '<i class="fas fa-exclamation-triangle text-danger"></i> Error general: ' . htmlspecialchars($e->getMessage());
                            echo '</div>';
                        }
                    } else {
                        ?>
                        <div class="alert alert-info">
                            <h4><i class="fas fa-info-circle"></i> Instalación del Sistema</h4>
                            <p>Este instalador creará todas las tablas necesarias para el funcionamiento del sistema:</p>
                            <ul>
                                <li>✓ Sistema multiempresa con aislamiento de datos</li>
                                <li>✓ Control de suscripciones ($180 USD anuales)</li>
                                <li>✓ Facturación electrónica chilena (TODOS los documentos del SII)</li>
                                <li>✓ Contabilidad completa con plan de cuentas chileno</li>
                                <li>✓ Sistema de folios CAF del SII</li>
                                <li>✓ Punto de venta con inventario</li>
                                <li>✓ Sistema multimoneda (CLP, USD, EUR, UF)</li>
                                <li>✓ Usuario AUDITOREX CHILE con acceso libre</li>
                            </ul>
                        </div>

                        <div class="alert alert-warning">
                            <h5><i class="fas fa-exclamation-triangle"></i> Requisitos del Sistema</h5>
                            <ul class="mb-0">
                                <li>PHP 7.4 o superior con extensiones: PDO, OpenSSL, cURL, XML</li>
                                <li>MySQL 5.7 o superior / MariaDB 10.3+</li>
                                <li>Servidor web Apache o Nginx</li>
                                <li>Certificado digital para facturación electrónica (.p12/.pfx)</li>
                                <li>Archivos CAF descargados desde el portal SII</li>
                            </ul>
                        </div>

                        <form method="POST">
                            <div class="text-center">
                                <button type="submit" name="install" class="btn btn-install btn-lg">
                                    <i class="fas fa-download"></i> Iniciar Instalación del Sistema
                                </button>
                            </div>
                        </form>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>