<?php
// SISTEMA DE LOGIN - SISCONECTA ERP CORREGIDO
// login.php

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configuración de base de datos
$host = 'localhost';
$dbname = 'conectae_sisconecta';
$username = 'conectae_sisconectauser';
$password = 'pt125824caraud';

$error_mensaje = '';
$success_mensaje = '';

// Procesar login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $usuario = trim($_POST['usuario']);
    $password_input = $_POST['password'];
    
    if (!empty($usuario) && !empty($password_input)) {
        try {
            $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Buscar usuario directamente (username único en todo el sistema)
            $stmt = $pdo->prepare("
                SELECT u.*, e.* 
                FROM usuarios u 
                JOIN empresas e ON u.empresa_id = e.id 
                WHERE u.username = ? AND u.estado = 'activo' AND e.estado = 'activo'
            ");
            $stmt->execute([$usuario]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result && password_verify($password_input, $result['password'])) {
                // Verificar vencimiento de suscripción (excepto AUDITOREX CHILE)
                if ($result['codigo_empresa'] !== 'AUDITOREX_CHILE') {
                    $fecha_actual = new DateTime();
                    $fecha_vencimiento = new DateTime($result['fecha_vencimiento']);
                    
                    if ($fecha_actual > $fecha_vencimiento) {
                        $error_mensaje = 'Suscripción vencida. Contacte al administrador para renovar. Costo: $180 USD anuales.';
                    }
                }
                
                if (empty($error_mensaje)) {
                    // Login exitoso
                    $_SESSION['user_id'] = $result['id'];
                    $_SESSION['empresa_id'] = $result['empresa_id'];
                    $_SESSION['username'] = $result['username'];
                    $_SESSION['nombre'] = $result['nombre'];
                    $_SESSION['rol'] = $result['rol'];
                    $_SESSION['empresa_codigo'] = $result['codigo_empresa'];
                    $_SESSION['empresa_razon_social'] = $result['razon_social'];
                    $_SESSION['empresa_rut'] = $result['rut'];
                    $_SESSION['moneda_principal'] = $result['moneda_principal'];
                    
                    // Actualizar último acceso
                    $stmt = $pdo->prepare("UPDATE usuarios SET ultimo_acceso = NOW() WHERE id = ?");
                    $stmt->execute([$result['id']]);
                    
                    header('Location: dashboard.php');
                    exit;
                }
            } else {
                $error_mensaje = 'Usuario o contraseña incorrectos.';
            }
        } catch (PDOException $e) {
            $error_mensaje = 'Error de conexión: ' . $e->getMessage();
        }
    } else {
        $error_mensaje = 'Usuario y contraseña son obligatorios.';
    }
}

// Procesar registro de nueva empresa
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['registro'])) {
    $razon_social = trim($_POST['razon_social']);
    $rut = trim($_POST['rut']);
    $email = trim($_POST['email']);
    $telefono = trim($_POST['telefono']);
    $direccion = trim($_POST['direccion']);
    $usuario_admin = trim($_POST['usuario_admin']);
    $password_admin = $_POST['password_admin'];
    $nombre_admin = trim($_POST['nombre_admin']);
    
    if (!empty($razon_social) && !empty($rut) && !empty($email) && !empty($usuario_admin) && !empty($password_admin) && !empty($nombre_admin)) {
        try {
            $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Generar código único de empresa
            $codigo_empresa = strtoupper(substr(preg_replace('/[^A-Z0-9]/', '', $razon_social), 0, 10) . '_' . date('Y'));
            
            // Verificar que el código de empresa no exista
            $stmt = $pdo->prepare("SELECT id FROM empresas WHERE codigo_empresa = ?");
            $stmt->execute([$codigo_empresa]);
            if ($stmt->fetch()) {
                $codigo_empresa .= '_' . rand(100, 999);
            }
            
            // Verificar que el username sea único en TODO el sistema
            $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE username = ?");
            $stmt->execute([$usuario_admin]);
            if ($stmt->fetch()) {
                throw new Exception('El nombre de usuario ya existe en el sistema. Elija otro.');
            }
            
            // Fecha de vencimiento (365 días desde hoy)
            $fecha_vencimiento = date('Y-m-d', strtotime('+365 days'));
            
            $pdo->beginTransaction();
            
            // Insertar empresa
            $stmt = $pdo->prepare("
                INSERT INTO empresas (codigo_empresa, razon_social, rut, direccion, telefono, email, fecha_vencimiento, monto_suscripcion) 
                VALUES (?, ?, ?, ?, ?, ?, ?, 180.00)
            ");
            $stmt->execute([$codigo_empresa, $razon_social, $rut, $direccion, $telefono, $email, $fecha_vencimiento]);
            $empresa_id = $pdo->lastInsertId();
            
            // Insertar usuario administrador
            $password_hash = password_hash($password_admin, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("
                INSERT INTO usuarios (empresa_id, username, password, nombre, email, rol) 
                VALUES (?, ?, ?, ?, ?, 'admin')
            ");
            $stmt->execute([$empresa_id, $usuario_admin, $password_hash, $nombre_admin, $email]);
            $usuario_id = $pdo->lastInsertId();
            
            // Insertar monedas por defecto
            $monedas = [
                ['CLP', 'Peso Chileno', '$', 1.000000],
                ['USD', 'Dólar Estadounidense', 'US$', 800.000000],
                ['EUR', 'Euro', '€', 850.000000]
            ];
            
            foreach ($monedas as $moneda) {
                $stmt = $pdo->prepare("INSERT INTO monedas (empresa_id, codigo, nombre, simbolo, tasa_cambio) VALUES (?, ?, ?, ?, ?)");
                $stmt->execute(array_merge([$empresa_id], $moneda));
            }
            
            // Insertar plan de cuentas básico
            $plan_cuentas = [
                ['1', 'ACTIVOS', 'activo', null, 1],
                ['11', 'ACTIVOS CORRIENTES', 'activo', '1', 2],
                ['1101', 'CAJA', 'activo', '11', 3],
                ['1102', 'BANCOS', 'activo', '11', 3],
                ['1103', 'CLIENTES', 'activo', '11', 3],
                ['1104', 'EXISTENCIAS', 'activo', '11', 3],
                ['2', 'PASIVOS', 'pasivo', null, 1],
                ['21', 'PASIVOS CORRIENTES', 'pasivo', '2', 2],
                ['2101', 'PROVEEDORES', 'pasivo', '21', 3],
                ['2102', 'IVA DÉBITO FISCAL', 'pasivo', '21', 3],
                ['2103', 'IVA CRÉDITO FISCAL', 'activo', '21', 3],
                ['3', 'PATRIMONIO', 'patrimonio', null, 1],
                ['3101', 'CAPITAL', 'patrimonio', '3', 2],
                ['4', 'INGRESOS', 'ingreso', null, 1],
                ['4101', 'VENTAS', 'ingreso', '4', 2],
                ['5', 'GASTOS', 'gasto', null, 1],
                ['5101', 'COSTO DE VENTAS', 'gasto', '5', 2],
                ['5102', 'GASTOS ADMINISTRATIVOS', 'gasto', '5', 2]
            ];
            
            foreach ($plan_cuentas as $cuenta) {
                $stmt = $pdo->prepare("INSERT INTO plan_cuentas (empresa_id, codigo_cuenta, nombre_cuenta, tipo_cuenta, cuenta_padre, nivel) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute(array_merge([$empresa_id], $cuenta));
            }
            
            // Crear caja principal - CORREGIDO: usar el ID del usuario recién creado
            $stmt = $pdo->prepare("INSERT INTO cajas (empresa_id, nombre_caja, codigo_caja, saldo_inicial, saldo_actual, usuario_responsable) VALUES (?, 'Caja Principal', 'CAJ001', 0.00, 0.00, ?)");
            $stmt->execute([$empresa_id, $usuario_id]);
            
            $pdo->commit();
            
            $success_mensaje = "Empresa registrada exitosamente. Código: <strong>$codigo_empresa</strong><br>Usuario: <strong>$usuario_admin</strong><br>Suscripción válida hasta: <strong>$fecha_vencimiento</strong>";
            
        } catch (PDOException $e) {
            $pdo->rollBack();
            $error_mensaje = 'Error al registrar empresa: ' . $e->getMessage();
        }
    } else {
        $error_mensaje = 'Todos los campos son obligatorios para el registro.';
    }
}

// Crear usuario AUDITOREX automáticamente si no existe
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Verificar si existe AUDITOREX CHILE
    $stmt = $pdo->prepare("SELECT id FROM empresas WHERE codigo_empresa = 'AUDITOREX_CHILE'");
    $stmt->execute();
    $empresa_auditorex = $stmt->fetch();
    
    if (!$empresa_auditorex) {
        $pdo->beginTransaction();
        
        // Crear empresa AUDITOREX CHILE
        $stmt = $pdo->prepare("
            INSERT INTO empresas (codigo_empresa, razon_social, rut, direccion, email, fecha_vencimiento, monto_suscripcion) 
            VALUES ('AUDITOREX_CHILE', 'AUDITOREX CHILE SPA', '76.123.456-7', 'Santiago, Chile', 'admin@auditorex.cl', '2099-12-31', 0.00)
        ");
        $stmt->execute();
        $empresa_id = $pdo->lastInsertId();
        
        // Crear usuario auditorex
        $password_hash = password_hash('auditorex2025', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("
            INSERT INTO usuarios (empresa_id, username, password, nombre, email, rol) 
            VALUES (?, 'auditorex', ?, 'Administrador AUDITOREX', 'admin@auditorex.cl', 'auditor')
        ");
        $stmt->execute([$empresa_id, $password_hash]);
        $usuario_id = $pdo->lastInsertId();
        
        // Insertar monedas
        $monedas = [
            ['CLP', 'Peso Chileno', '$', 1.000000],
            ['USD', 'Dólar Estadounidense', 'US$', 800.000000],
            ['EUR', 'Euro', '€', 850.000000]
        ];
        
        foreach ($monedas as $moneda) {
            $stmt = $pdo->prepare("INSERT INTO monedas (empresa_id, codigo, nombre, simbolo, tasa_cambio) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute(array_merge([$empresa_id], $moneda));
        }
        
        // Insertar plan de cuentas
        $plan_cuentas = [
            ['1', 'ACTIVOS', 'activo', null, 1],
            ['11', 'ACTIVOS CORRIENTES', 'activo', '1', 2],
            ['1101', 'CAJA', 'activo', '11', 3],
            ['1102', 'BANCOS', 'activo', '11', 3],
            ['1103', 'CLIENTES', 'activo', '11', 3],
            ['1104', 'EXISTENCIAS', 'activo', '11', 3],
            ['2', 'PASIVOS', 'pasivo', null, 1],
            ['21', 'PASIVOS CORRIENTES', 'pasivo', '2', 2],
            ['2101', 'PROVEEDORES', 'pasivo', '21', 3],
            ['2102', 'IVA DÉBITO FISCAL', 'pasivo', '21', 3],
            ['2103', 'IVA CRÉDITO FISCAL', 'activo', '21', 3],
            ['3', 'PATRIMONIO', 'patrimonio', null, 1],
            ['3101', 'CAPITAL', 'patrimonio', '3', 2],
            ['4', 'INGRESOS', 'ingreso', null, 1],
            ['4101', 'VENTAS', 'ingreso', '4', 2],
            ['5', 'GASTOS', 'gasto', null, 1],
            ['5101', 'COSTO DE VENTAS', 'gasto', '5', 2],
            ['5102', 'GASTOS ADMINISTRATIVOS', 'gasto', '5', 2]
        ];
        
        foreach ($plan_cuentas as $cuenta) {
            $stmt = $pdo->prepare("INSERT INTO plan_cuentas (empresa_id, codigo_cuenta, nombre_cuenta, tipo_cuenta, cuenta_padre, nivel) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->execute(array_merge([$empresa_id], $cuenta));
        }
        
        // Crear caja principal
        $stmt = $pdo->prepare("INSERT INTO cajas (empresa_id, nombre_caja, codigo_caja, saldo_inicial, saldo_actual, usuario_responsable) VALUES (?, 'Caja Principal', 'CAJ001', 0.00, 0.00, ?)");
        $stmt->execute([$empresa_id, $usuario_id]);
        
        $pdo->commit();
    }
} catch (PDOException $e) {
    // Si hay error en la creación automática, continuar normal
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SISCONECTA ERP - Sistema de Gestión Empresarial Chile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            overflow-x: hidden;
        }
        
        .animated-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            animation: gradientShift 8s ease infinite;
        }
        
        .animated-bg::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: float 20s linear infinite;
        }
        
        @keyframes gradientShift {
            0%, 100% { background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%); }
            33% { background: linear-gradient(135deg, #f093fb 0%, #667eea 50%, #764ba2 100%); }
            66% { background: linear-gradient(135deg, #764ba2 0%, #f093fb 50%, #667eea 100%); }
        }
        
        @keyframes float {
            0% { transform: translate(-50%, -50%) rotate(0deg); }
            100% { transform: translate(-50%, -50%) rotate(360deg); }
        }
        
        .hero-section {
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
        }
        
        .login-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 25px;
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255,255,255,0.2);
            overflow: hidden;
            animation: slideInUp 1s ease-out;
        }
        
        @keyframes slideInUp {
            0% { opacity: 0; transform: translateY(50px); }
            100% { opacity: 1; transform: translateY(0); }
        }
        
        .brand-section {
            background: linear-gradient(45deg, #2c3e50, #34495e);
            color: white;
            padding: 60px 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .brand-section::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 30px 30px;
            animation: rotate 30s linear infinite;
        }
        
        @keyframes rotate {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .brand-logo {
            font-size: 4rem;
            margin-bottom: 20px;
            position: relative;
            z-index: 2;
        }
        
        .brand-title {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            position: relative;
            z-index: 2;
        }
        
        .brand-subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-bottom: 30px;
            position: relative;
            z-index: 2;
        }
        
        .features-list {
            list-style: none;
            text-align: left;
            position: relative;
            z-index: 2;
        }
        
        .features-list li {
            padding: 8px 0;
            font-size: 0.95rem;
        }
        
        .features-list i {
            color: #1abc9c;
            margin-right: 10px;
        }
        
        .form-section {
            padding: 60px 40px;
        }
        
        .nav-tabs {
            border: none;
            margin-bottom: 30px;
        }
        
        .nav-tabs .nav-link {
            border: none;
            color: #666;
            font-weight: 500;
            padding: 15px 25px;
            border-radius: 50px;
            margin-right: 10px;
            transition: all 0.3s ease;
        }
        
        .nav-tabs .nav-link.active {
            background: linear-gradient(45deg, #667eea, #764ba2);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102,126,234,0.3);
        }
        
        .form-floating {
            margin-bottom: 20px;
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 15px;
            padding: 20px 15px 10px 15px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: rgba(255,255,255,0.8);
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102,126,234,0.25);
            background: white;
        }
        
        .form-label {
            color: #666;
            font-weight: 500;
        }
        
        .btn-login {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
            border-radius: 15px;
            padding: 15px 40px;
            font-weight: 600;
            color: white;
            width: 100%;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 30px rgba(102,126,234,0.4);
            background: linear-gradient(45deg, #764ba2, #667eea);
        }
        
        .btn-register {
            background: linear-gradient(45deg, #1abc9c, #16a085);
            border: none;
            border-radius: 15px;
            padding: 15px 40px;
            font-weight: 600;
            color: white;
            width: 100%;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn-register:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 30px rgba(26,188,156,0.4);
            background: linear-gradient(45deg, #16a085, #1abc9c);
        }
        
        .alert {
            border: none;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 25px;
            font-weight: 500;
        }
        
        .alert-danger {
            background: linear-gradient(45deg, #e74c3c, #c0392b);
            color: white;
        }
        
        .alert-success {
            background: linear-gradient(45deg, #27ae60, #229954);
            color: white;
        }
        
        .pricing-badge {
            background: linear-gradient(45deg, #f39c12, #e67e22);
            color: white;
            padding: 10px 20px;
            border-radius: 50px;
            font-weight: 600;
            margin: 20px 0;
            display: inline-block;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        .footer-info {
            text-align: center;
            margin-top: 30px;
            color: #666;
            font-size: 0.9rem;
        }
        
        .form-check-input:checked {
            background-color: #667eea;
            border-color: #667eea;
        }
        
        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #666;
            z-index: 10;
        }
        
        .input-group {
            position: relative;
        }
        
        .auditorex-info {
            background: linear-gradient(45deg, #3498db, #2980b9);
            color: white;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .brand-section, .form-section {
                padding: 40px 30px;
            }
            
            .brand-title {
                font-size: 2rem;
            }
            
            .brand-logo {
                font-size: 3rem;
            }
        }
    </style>
</head>
<body>
    <div class="animated-bg"></div>
    
    <section class="hero-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-10 col-lg-11">
                    <div class="login-container">
                        <div class="row g-0">
                            <!-- Sección de Marca -->
                            <div class="col-lg-6">
                                <div class="brand-section h-100 d-flex flex-column justify-content-center">
                                    <div class="brand-logo">
                                        <i class="fas fa-chart-line"></i>
                                    </div>
                                    <h1 class="brand-title">SISCONECTA</h1>
                                    <h2 class="h4 brand-subtitle">ERP Sistema de Gestión Empresarial</h2>
                                    <p class="mb-4">Solución integral para empresas chilenas con facturación electrónica y contabilidad completa.</p>
                                    
                                    <ul class="features-list">
                                        <li><i class="fas fa-check-circle"></i> Facturación Electrónica (SII)</li>
                                        <li><i class="fas fa-check-circle"></i> Contabilidad F29 / F22</li>
                                        <li><i class="fas fa-check-circle"></i> Punto de Venta + Inventario</li>
                                        <li><i class="fas fa-check-circle"></i> Sistema Multiempresa</li>
                                        <li><i class="fas fa-check-circle"></i> Soporte Multimoneda</li>
                                        <li><i class="fas fa-check-circle"></i> Reportes Tributarios</li>
                                        <li><i class="fas fa-check-circle"></i> Control de Stock</li>
                                        <li><i class="fas fa-check-circle"></i> Gestión de Cajas</li>
                                    </ul>
                                    
                                    <div class="pricing-badge">
                                        <i class="fas fa-dollar-sign"></i> $180 USD / Año
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Sección de Formularios -->
                            <div class="col-lg-6">
                                <div class="form-section">
                                    <ul class="nav nav-tabs" id="authTabs" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="login-tab" data-bs-toggle="tab" data-bs-target="#login" type="button" role="tab">
                                                <i class="fas fa-sign-in-alt"></i> Acceder
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="register-tab" data-bs-toggle="tab" data-bs-target="#register" type="button" role="tab">
                                                <i class="fas fa-user-plus"></i> Registrar Empresa
                                            </button>
                                        </li>
                                    </ul>
                                    
                                    <div class="tab-content" id="authTabsContent">
                                        <!-- Login -->
                                        <div class="tab-pane fade show active" id="login" role="tabpanel">
                                            <div class="auditorex-info">
                                                <h6><i class="fas fa-users"></i> Usuarios del Sistema</h6>
                                                <small>• <strong>auditorex</strong> (Administrador AUDITOREX - Acceso libre)<br>
                                                       • <strong>auditorexchile</strong> (Carlos Rivera - Admin)</small>
                                            </div>
                                            
                                            <?php if (!empty($error_mensaje) && !isset($_POST['registro'])): ?>
                                                <div class="alert alert-danger">
                                                    <i class="fas fa-exclamation-triangle"></i> <?php echo $error_mensaje; ?>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <form method="POST" id="loginForm">
                                                <div class="form-floating">
                                                    <input type="text" class="form-control" id="usuario" name="usuario" placeholder="Usuario" required>
                                                    <label for="usuario"><i class="fas fa-user"></i> Usuario</label>
                                                </div>
                                                
                                                <div class="form-floating">
                                                    <div class="input-group">
                                                        <input type="password" class="form-control" id="password" name="password" placeholder="Contraseña" required>
                                                        <span class="password-toggle" onclick="togglePassword('password')">
                                                            <i class="fas fa-eye"></i>
                                                        </span>
                                                    </div>
                                                    <label for="password"><i class="fas fa-lock"></i> Contraseña</label>
                                                </div>
                                                
                                                <div class="form-check mb-3">
                                                    <input class="form-check-input" type="checkbox" id="remember">
                                                    <label class="form-check-label" for="remember">
                                                        Recordar sesión
                                                    </label>
                                                </div>
                                                
                                                <button type="submit" name="login" class="btn btn-login">
                                                    <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                                                </button>
                                            </form>
                                        </div>
                                        
                                        <!-- Registro -->
                                        <div class="tab-pane fade" id="register" role="tabpanel">
                                            <?php if (!empty($error_mensaje) && isset($_POST['registro'])): ?>
                                                <div class="alert alert-danger">
                                                    <i class="fas fa-exclamation-triangle"></i> <?php echo $error_mensaje; ?>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($success_mensaje)): ?>
                                                <div class="alert alert-success">
                                                    <i class="fas fa-check-circle"></i> <?php echo $success_mensaje; ?>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <form method="POST" id="registerForm">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-floating">
                                                            <input type="text" class="form-control" id="razon_social" name="razon_social" placeholder="Razón Social" required>
                                                            <label for="razon_social"><i class="fas fa-building"></i> Razón Social</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-floating">
                                                            <input type="text" class="form-control" id="rut" name="rut" placeholder="RUT" required>
                                                            <label for="rut"><i class="fas fa-id-card"></i> RUT</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-floating">
                                                            <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
                                                            <label for="email"><i class="fas fa-envelope"></i> Email</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-floating">
                                                            <input type="tel" class="form-control" id="telefono" name="telefono" placeholder="Teléfono">
                                                            <label for="telefono"><i class="fas fa-phone"></i> Teléfono</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-floating">
                                                    <textarea class="form-control" id="direccion" name="direccion" placeholder="Dirección" style="height: 80px"></textarea>
                                                    <label for="direccion"><i class="fas fa-map-marker-alt"></i> Dirección</label>
                                                </div>
                                                
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-floating">
                                                            <input type="text" class="form-control" id="usuario_admin" name="usuario_admin" placeholder="Usuario Admin" required>
                                                            <label for="usuario_admin"><i class="fas fa-user-shield"></i> Usuario Admin</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-floating">
                                                            <input type="text" class="form-control" id="nombre_admin" name="nombre_admin" placeholder="Nombre Admin" required>
                                                            <label for="nombre_admin"><i class="fas fa-user"></i> Nombre Admin</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-floating">
                                                    <div class="input-group">
                                                        <input type="password" class="form-control" id="password_admin" name="password_admin" placeholder="Contraseña Admin" required>
                                                        <span class="password-toggle" onclick="togglePassword('password_admin')">
                                                            <i class="fas fa-eye"></i>
                                                        </span>
                                                    </div>
                                                    <label for="password_admin"><i class="fas fa-lock"></i> Contraseña Admin</label>
                                                </div>
                                                
                                                <div class="form-check mb-3">
                                                    <input class="form-check-input" type="checkbox" id="terms" required>
                                                    <label class="form-check-label" for="terms">
                                                        Acepto los términos y condiciones del servicio
                                                    </label>
                                                </div>
                                                
                                                <button type="submit" name="registro" class="btn btn-register">
                                                    <i class="fas fa-user-plus"></i> Registrar Empresa
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                    
                                    <div class="footer-info">
                                        <p><i class="fas fa-shield-alt text-success"></i> Conexión segura SSL</p>
                                        <p><small>&copy; 2025 SISCONECTA ERP - Sistema de Gestión Empresarial Chile</small></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function togglePassword(inputId) {
            const passwordInput = document.getElementById(inputId);
            const toggleIcon = passwordInput.parentNode.querySelector('.password-toggle i');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleIcon.className = 'fas fa-eye-slash';
            } else {
                passwordInput.type = 'password';
                toggleIcon.className = 'fas fa-eye';
            }
        }
        
        // Validación de RUT chileno
        document.getElementById('rut').addEventListener('input', function(e) {
            let rut = e.target.value.replace(/[^0-9kK]/g, '');
            if (rut.length > 1) {
                rut = rut.slice(0, -1) + '-' + rut.slice(-1);
            }
            if (rut.length > 4) {
                rut = rut.slice(0, -4) + '.' + rut.slice(-4);
            }
            if (rut.length > 8) {
                rut = rut.slice(0, -8) + '.' + rut.slice(-8);
            }
            e.target.value = rut;
        });
        
        // Animaciones al cargar
        document.addEventListener('DOMContentLoaded', function() {
            const formElements = document.querySelectorAll('.form-floating');
            formElements.forEach((element, index) => {
                element.style.opacity = '0';
                element.style.transform = 'translateY(20px)';
                setTimeout(() => {
                    element.style.transition = 'all 0.5s ease';
                    element.style.opacity = '1';
                    element.style.transform = 'translateY(0)';
                }, index * 100);
            });
        });
    </script>
</body>
</html>