<?php
// MÓDULO DE REPORTES - SISCONECTA ERP
// reportes.php

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar sesión activa
if (!isset($_SESSION['user_id']) || !isset($_SESSION['empresa_id'])) {
    header('Location: login.php');
    exit;
}

// Configuración de base de datos
$host = 'localhost';
$dbname = 'conectae_sisconecta';
$username = 'conectae_sisconectauser';
$password = 'pt125824caraud';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $empresa_id = $_SESSION['empresa_id'];
    
    // Verificar estado de empresa
    $stmt = $pdo->prepare("SELECT * FROM empresas WHERE id = ? AND estado = 'activo'");
    $stmt->execute([$empresa_id]);
    $empresa = $stmt->fetch();
    
    if (!$empresa) {
        session_destroy();
        header('Location: login.php?error=empresa_inactiva');
        exit;
    }
    
    // Verificar vencimiento (excepto AUDITOREX CHILE)
    if (($empresa['codigo_empresa'] ?? '') !== 'AUDITOREX_CHILE') {
        $fecha_actual = new DateTime();
        $fecha_vencimiento = new DateTime($empresa['fecha_vencimiento'] ?? '2024-12-31');
        
        if ($fecha_actual > $fecha_vencimiento) {
            session_destroy();
            header('Location: login.php?error=suscripcion_vencida');
            exit;
        }
    }
    
    $reporte = $_GET['reporte'] ?? 'dashboard';
    $fecha_desde = $_GET['fecha_desde'] ?? date('Y-m-01');
    $fecha_hasta = $_GET['fecha_hasta'] ?? date('Y-m-t');
    
    // Reporte de Ventas
    if ($reporte === 'ventas') {
        $stmt = $pdo->prepare("
            SELECT 
                dt.fecha_emision,
                dt.tipo_documento,
                dt.numero_documento,
                dt.rut_cliente,
                dt.razon_social_cliente,
                dt.subtotal,
                dt.iva,
                dt.total,
                dt.moneda,
                dt.estado,
                COUNT(dd.id) as items
            FROM documentos_tributarios dt
            LEFT JOIN documento_detalles dd ON dt.id = dd.documento_id
            WHERE dt.empresa_id = ? 
            AND dt.tipo_documento IN ('factura', 'boleta')
            AND dt.fecha_emision BETWEEN ? AND ?
            AND dt.estado != 'anulado'
            GROUP BY dt.id
            ORDER BY dt.fecha_emision DESC, dt.numero_documento ASC
        ");
        $stmt->execute([$empresa_id, $fecha_desde, $fecha_hasta]);
        $datos_ventas = $stmt->fetchAll();
        
        // Resumen de ventas
        $stmt = $pdo->prepare("
            SELECT 
                tipo_documento,
                COUNT(*) as cantidad,
                SUM(subtotal) as total_subtotal,
                SUM(iva) as total_iva,
                SUM(total) as total_final
            FROM documentos_tributarios
            WHERE empresa_id = ? 
            AND tipo_documento IN ('factura', 'boleta')
            AND fecha_emision BETWEEN ? AND ?
            AND estado != 'anulado'
            GROUP BY tipo_documento
        ");
        $stmt->execute([$empresa_id, $fecha_desde, $fecha_hasta]);
        $resumen_ventas = $stmt->fetchAll();
    }
    
    // Reporte de Inventario
    if ($reporte === 'inventario') {
        $stmt = $pdo->prepare("
            SELECT 
                p.*,
                COALESCE(SUM(CASE WHEN dd.cantidad > 0 THEN dd.cantidad ELSE 0 END), 0) as total_vendido,
                (p.stock_actual * p.precio_venta) as valor_inventario
            FROM productos p
            LEFT JOIN documento_detalles dd ON p.id = dd.producto_id
            LEFT JOIN documentos_tributarios dt ON dd.documento_id = dt.id 
                AND dt.fecha_emision BETWEEN ? AND ? 
                AND dt.estado != 'anulado'
            WHERE p.empresa_id = ? AND p.activo = 1
            GROUP BY p.id
            ORDER BY p.nombre ASC
        ");
        $stmt->execute([$fecha_desde, $fecha_hasta, $empresa_id]);
        $datos_inventario = $stmt->fetchAll();
        
        // Estadísticas de inventario
        $total_productos = count($datos_inventario);
        $valor_total_inventario = array_sum(array_column($datos_inventario, 'valor_inventario'));
        $productos_sin_stock = count(array_filter($datos_inventario, fn($p) => $p['stock_actual'] <= 0));
        $productos_stock_bajo = count(array_filter($datos_inventario, fn($p) => $p['stock_actual'] <= $p['stock_minimo']));
    }
    
    // Reporte Financiero
    if ($reporte === 'financiero') {
        // Balance General simplificado
        $stmt = $pdo->prepare("
            SELECT 
                pc.tipo_cuenta,
                pc.codigo_cuenta,
                pc.nombre_cuenta,
                COALESCE(SUM(mc.debe), 0) as total_debe,
                COALESCE(SUM(mc.haber), 0) as total_haber,
                (COALESCE(SUM(mc.debe), 0) - COALESCE(SUM(mc.haber), 0)) as saldo
            FROM plan_cuentas pc
            LEFT JOIN movimientos_contables mc ON pc.codigo_cuenta = mc.cuenta_contable
            LEFT JOIN asientos_contables ac ON mc.asiento_id = ac.id 
                AND ac.empresa_id = ? 
                AND ac.fecha BETWEEN ? AND ?
                AND ac.estado = 'contabilizado'
            WHERE (pc.empresa_id = ? OR pc.empresa_id IS NULL) 
            AND pc.activo = 1
            GROUP BY pc.codigo_cuenta, pc.nombre_cuenta, pc.tipo_cuenta
            HAVING (SUM(mc.debe) IS NOT NULL OR SUM(mc.haber) IS NOT NULL)
            ORDER BY pc.codigo_cuenta
        ");
        $stmt->execute([$empresa_id, $fecha_desde, $fecha_hasta, $empresa_id]);
        $balance_general = $stmt->fetchAll();
        
        // Agrupar por tipo de cuenta
        $activos = array_filter($balance_general, fn($c) => $c['tipo_cuenta'] === 'activo');
        $pasivos = array_filter($balance_general, fn($c) => $c['tipo_cuenta'] === 'pasivo');
        $patrimonio = array_filter($balance_general, fn($c) => $c['tipo_cuenta'] === 'patrimonio');
        $ingresos = array_filter($balance_general, fn($c) => $c['tipo_cuenta'] === 'ingreso');
        $gastos = array_filter($balance_general, fn($c) => $c['tipo_cuenta'] === 'gasto');
        
        $total_activos = array_sum(array_column($activos, 'saldo'));
        $total_pasivos = array_sum(array_column($pasivos, 'saldo'));
        $total_patrimonio = array_sum(array_column($patrimonio, 'saldo'));
        $total_ingresos = array_sum(array_column($ingresos, 'saldo'));
        $total_gastos = array_sum(array_column($gastos, 'saldo'));
        
        $utilidad_perdida = $total_ingresos - abs($total_gastos);
    }
    
    // Reporte F29 (IVA)
    if ($reporte === 'f29') {
        // Ventas (IVA Débito Fiscal)
        $stmt = $pdo->prepare("
            SELECT 
                SUM(subtotal) as ventas_netas,
                SUM(iva) as iva_debito_fiscal,
                COUNT(*) as documentos_emitidos
            FROM documentos_tributarios
            WHERE empresa_id = ? 
            AND tipo_documento IN ('factura', 'boleta')
            AND fecha_emision BETWEEN ? AND ?
            AND estado != 'anulado'
        ");
        $stmt->execute([$empresa_id, $fecha_desde, $fecha_hasta]);
        $datos_ventas_f29 = $stmt->fetch();
        
        // Compras (IVA Crédito Fiscal) - simulado
        $stmt = $pdo->prepare("
            SELECT 
                COALESCE(SUM(debe), 0) as iva_credito_fiscal
            FROM movimientos_contables mc
            JOIN asientos_contables ac ON mc.asiento_id = ac.id
            WHERE ac.empresa_id = ? 
            AND mc.cuenta_contable LIKE '%210202%'
            AND ac.fecha BETWEEN ? AND ?
            AND ac.estado = 'contabilizado'
        ");
        $stmt->execute([$empresa_id, $fecha_desde, $fecha_hasta]);
        $iva_credito = $stmt->fetch()['iva_credito_fiscal'] ?? 0;
        
        $iva_a_pagar = max(0, ($datos_ventas_f29['iva_debito_fiscal'] ?? 0) - $iva_credito);
    }
    
    // Productos más vendidos
    if ($reporte === 'productos_vendidos') {
        $stmt = $pdo->prepare("
            SELECT 
                p.nombre,
                p.codigo,
                p.precio_venta,
                SUM(dd.cantidad) as total_vendido,
                SUM(dd.subtotal) as total_ventas,
                COUNT(DISTINCT dt.id) as documentos
            FROM productos p
            JOIN documento_detalles dd ON p.id = dd.producto_id
            JOIN documentos_tributarios dt ON dd.documento_id = dt.id
            WHERE p.empresa_id = ? 
            AND dt.fecha_emision BETWEEN ? AND ?
            AND dt.estado != 'anulado'
            GROUP BY p.id
            ORDER BY total_vendido DESC
            LIMIT 20
        ");
        $stmt->execute([$empresa_id, $fecha_desde, $fecha_hasta]);
        $productos_vendidos = $stmt->fetchAll();
    }
    
} catch (PDOException $e) {
    die('Error de conexión: ' . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reportes - SISCONECTA ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .main-container {
            padding: 20px;
            max-width: 1600px;
            margin: 0 auto;
        }
        
        .header-section {
            background: linear-gradient(45deg, #2c3e50, #34495e);
            color: white;
            padding: 25px 30px;
            border-radius: 15px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        
        .header-title {
            font-size: 1.9rem;
            font-weight: 700;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .header-actions {
            display: flex;
            gap: 15px;
        }
        
        .btn-header {
            background: rgba(255,255,255,0.15);
            border: 2px solid rgba(255,255,255,0.3);
            color: white;
            border-radius: 10px;
            padding: 12px 20px;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .btn-header:hover {
            background: rgba(255,255,255,0.25);
            color: white;
            transform: translateY(-2px);
        }
        
        .content-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 25px;
        }
        
        .report-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .report-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border-left: 5px solid;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .report-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.15);
        }
        
        .report-card.ventas { border-left-color: #3498db; }
        .report-card.inventario { border-left-color: #27ae60; }
        .report-card.financiero { border-left-color: #9b59b6; }
        .report-card.tributario { border-left-color: #e74c3c; }
        
        .report-icon {
            font-size: 3rem;
            margin-bottom: 15px;
            opacity: 0.8;
        }
        
        .report-title {
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 10px;
            color: #2c3e50;
        }
        
        .report-description {
            color: #666;
            font-size: 0.95rem;
            margin-bottom: 20px;
        }
        
        .nav-pills .nav-link {
            border-radius: 10px;
            font-weight: 600;
            margin-right: 10px;
            padding: 12px 20px;
        }
        
        .nav-pills .nav-link.active {
            background: linear-gradient(135deg, #3498db, #2980b9);
        }
        
        .table {
            border-radius: 15px;
            overflow: hidden;
        }
        
        .table th {
            background: linear-gradient(135deg, #34495e, #2c3e50);
            color: white;
            border: none;
            font-weight: 700;
            padding: 15px 12px;
        }
        
        .table td {
            padding: 15px 12px;
            vertical-align: middle;
            border-top: 1px solid #f1f3f4;
        }
        
        .table tbody tr:hover {
            background: #f8f9fa;
        }
        
        .stats-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-item {
            background: linear-gradient(135deg, #f8f9fa, #ffffff);
            padding: 20px;
            border-radius: 15px;
            text-align: center;
            border-left: 4px solid #3498db;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: 800;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #666;
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        .chart-container {
            position: relative;
            height: 300px;
            margin-bottom: 30px;
        }
        
        .filters-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 25px;
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 12px 15px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #3498db, #2980b9);
            border: none;
            border-radius: 10px;
            padding: 12px 25px;
            font-weight: 600;
        }
        
        .badge {
            padding: 8px 12px;
            border-radius: 20px;
            font-weight: 600;
        }
        
        .balance-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .balance-group {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 15px;
        }
        
        .balance-title {
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 15px;
            color: #2c3e50;
            text-align: center;
        }
        
        .cuenta-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }
        
        .cuenta-item:last-child {
            border-bottom: none;
            font-weight: 700;
            background: #e9ecef;
            padding: 12px;
            border-radius: 8px;
            margin-top: 10px;
        }
        
        @media print {
            .header-section, .btn-header, .filters-section {
                display: none !important;
            }
            
            body {
                background: white !important;
            }
            
            .content-card {
                box-shadow: none !important;
                border: 1px solid #ddd !important;
            }
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Header -->
        <div class="header-section">
            <h1 class="header-title">
                <i class="fas fa-chart-bar"></i>
                Centro de Reportes
            </h1>
            <div class="header-actions">
                <a href="dashboard.php" class="btn-header">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="contabilidad.php" class="btn-header">
                    <i class="fas fa-calculator"></i> Contabilidad
                </a>
                <button class="btn-header" onclick="window.print()">
                    <i class="fas fa-print"></i> Imprimir
                </button>
            </div>
        </div>

        <?php if ($reporte === 'dashboard'): ?>
            <!-- Dashboard de Reportes -->
            <div class="content-card">
                <h3><i class="fas fa-chart-line"></i> Seleccionar Reporte</h3>
                <p class="text-muted mb-4">Escolha o tipo de relatório que deseja gerar</p>
                
                <div class="report-grid">
                    <div class="report-card ventas" onclick="location.href='?reporte=ventas'">
                        <div class="report-icon text-primary">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div class="report-title">Reporte de Ventas</div>
                        <div class="report-description">
                            Análisis detallado de facturas y boletas emitidas, totales por período y resúmenes por tipo de documento.
                        </div>
                        <div class="text-primary">
                            <i class="fas fa-arrow-right"></i> Generar Reporte
                        </div>
                    </div>
                    
                    <div class="report-card inventario" onclick="location.href='?reporte=inventario'">
                        <div class="report-icon text-success">
                            <i class="fas fa-boxes"></i>
                        </div>
                        <div class="report-title">Reporte de Inventario</div>
                        <div class="report-description">
                            Estado actual del inventario, productos con stock bajo, valorización y movimientos de productos.
                        </div>
                        <div class="text-success">
                            <i class="fas fa-arrow-right"></i> Generar Reporte
                        </div>
                    </div>
                    
                    <div class="report-card financiero" onclick="location.href='?reporte=financiero'">
                        <div class="report-icon text-purple">
                            <i class="fas fa-balance-scale"></i>
                        </div>
                        <div class="report-title">Reporte Financiero</div>
                        <div class="report-description">
                            Balance general simplificado, estado de resultados y análisis de cuentas contables por período.
                        </div>
                        <div class="text-purple">
                            <i class="fas fa-arrow-right"></i> Generar Reporte
                        </div>
                    </div>
                    
                    <div class="report-card tributario" onclick="location.href='?reporte=f29'">
                        <div class="report-icon text-danger">
                            <i class="fas fa-file-invoice-dollar"></i>
                        </div>
                        <div class="report-title">Reporte F29 (IVA)</div>
                        <div class="report-description">
                            Información para declaración mensual de IVA, débito y crédito fiscal, documentos emitidos.
                        </div>
                        <div class="text-danger">
                            <i class="fas fa-arrow-right"></i> Generar Reporte
                        </div>
                    </div>
                    
                    <div class="report-card ventas" onclick="location.href='?reporte=productos_vendidos'">
                        <div class="report-icon text-info">
                            <i class="fas fa-trophy"></i>
                        </div>
                        <div class="report-title">Productos Más Vendidos</div>
                        <div class="report-description">
                            Ranking de productos por cantidad vendida, análisis de rendimiento y estadísticas de ventas.
                        </div>
                        <div class="text-info">
                            <i class="fas fa-arrow-right"></i> Generar Reporte
                        </div>
                    </div>
                    
                    <div class="report-card inventario" onclick="alert('Próximamente: Reporte de Clientes')">
                        <div class="report-icon text-warning">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="report-title">Reporte de Clientes</div>
                        <div class="report-description">
                            Análisis de clientes, top compradores, cuentas por cobrar y segmentación de clientela.
                        </div>
                        <div class="text-warning">
                            <i class="fas fa-clock"></i> Próximamente
                        </div>
                    </div>
                </div>
            </div>

        <?php elseif ($reporte === 'ventas'): ?>
            <!-- Reporte de Ventas -->
            <div class="content-card">
                <h3><i class="fas fa-chart-line"></i> Reporte de Ventas</h3>
                
                <!-- Filtros -->
                <div class="filters-section">
                    <form method="GET" class="row g-3">
                        <input type="hidden" name="reporte" value="ventas">
                        <div class="col-md-4">
                            <label class="form-label">Fecha Desde</label>
                            <input type="date" name="fecha_desde" class="form-control" value="<?php echo $fecha_desde; ?>">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Fecha Hasta</label>
                            <input type="date" name="fecha_hasta" class="form-control" value="<?php echo $fecha_hasta; ?>">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">&nbsp;</label>
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="fas fa-filter"></i> Filtrar
                            </button>
                        </div>
                    </form>
                </div>
                
                <!-- Resumen de Ventas -->
                <h5><i class="fas fa-chart-pie"></i> Resumen por Tipo de Documento</h5>
                <div class="stats-row">
                    <?php foreach ($resumen_ventas as $resumen): ?>
                        <div class="stat-item">
                            <div class="stat-value"><?php echo number_format($resumen['cantidad']); ?></div>
                            <div class="stat-label"><?php echo ucfirst($resumen['tipo_documento']); ?>s</div>
                            <div class="text-success mt-2">
                                <strong><?php echo $empresa['moneda_principal']; ?> <?php echo number_format($resumen['total_final'], 0); ?></strong>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- Detalle de Ventas -->
                <h5><i class="fas fa-list"></i> Detalle de Documentos</h5>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Tipo</th>
                                <th>Número</th>
                                <th>Cliente</th>
                                <th>RUT</th>
                                <th>Subtotal</th>
                                <th>IVA</th>
                                <th>Total</th>
                                <th>Items</th>
                                <th>Estado</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($datos_ventas as $venta): ?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($venta['fecha_emision'])); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $venta['tipo_documento'] === 'factura' ? 'primary' : 'success'; ?>">
                                            <?php echo ucfirst($venta['tipo_documento']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($venta['numero_documento']); ?></td>
                                    <td><?php echo htmlspecialchars($venta['razon_social_cliente']); ?></td>
                                    <td><?php echo htmlspecialchars($venta['rut_cliente']); ?></td>
                                    <td><?php echo number_format($venta['subtotal'], 0); ?></td>
                                    <td><?php echo number_format($venta['iva'], 0); ?></td>
                                    <td><strong><?php echo number_format($venta['total'], 0); ?></strong></td>
                                    <td><?php echo $venta['items']; ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $venta['estado'] === 'emitido' ? 'success' : 'warning'; ?>">
                                            <?php echo ucfirst($venta['estado']); ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        <?php elseif ($reporte === 'inventario'): ?>
            <!-- Reporte de Inventario -->
            <div class="content-card">
                <h3><i class="fas fa-boxes"></i> Reporte de Inventario</h3>
                
                <!-- Estadísticas de Inventario -->
                <div class="stats-row">
                    <div class="stat-item">
                        <div class="stat-value"><?php echo $total_productos; ?></div>
                        <div class="stat-label">Total Productos</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?php echo $empresa['moneda_principal']; ?> <?php echo number_format($valor_total_inventario, 0); ?></div>
                        <div class="stat-label">Valor Total Inventario</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value text-danger"><?php echo $productos_sin_stock; ?></div>
                        <div class="stat-label">Sin Stock</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value text-warning"><?php echo $productos_stock_bajo; ?></div>
                        <div class="stat-label">Stock Bajo</div>
                    </div>
                </div>
                
                <!-- Detalle de Inventario -->
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Producto</th>
                                <th>Categoría</th>
                                <th>Stock Actual</th>
                                <th>Stock Mínimo</th>
                                <th>Precio Venta</th>
                                <th>Valor Inventario</th>
                                <th>Vendido (Período)</th>
                                <th>Estado</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($datos_inventario as $producto): ?>
                                <tr>
                                    <td><strong><?php echo htmlspecialchars($producto['codigo']); ?></strong></td>
                                    <td><?php echo htmlspecialchars($producto['nombre']); ?></td>
                                    <td><?php echo htmlspecialchars($producto['categoria'] ?? 'Sin categoría'); ?></td>
                                    <td>
                                        <span class="badge bg-<?php 
                                            if ($producto['stock_actual'] <= 0) echo 'danger';
                                            elseif ($producto['stock_actual'] <= $producto['stock_minimo']) echo 'warning';
                                            else echo 'success';
                                        ?>">
                                            <?php echo number_format($producto['stock_actual']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo number_format($producto['stock_minimo']); ?></td>
                                    <td><?php echo number_format($producto['precio_venta'], 0); ?></td>
                                    <td><?php echo number_format($producto['valor_inventario'], 0); ?></td>
                                    <td><?php echo number_format($producto['total_vendido']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $producto['activo'] ? 'success' : 'secondary'; ?>">
                                            <?php echo $producto['activo'] ? 'Activo' : 'Inactivo'; ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        <?php elseif ($reporte === 'financiero'): ?>
            <!-- Reporte Financiero -->
            <div class="content-card">
                <h3><i class="fas fa-balance-scale"></i> Reporte Financiero</h3>
                <p class="text-muted">Período: <?php echo date('d/m/Y', strtotime($fecha_desde)); ?> - <?php echo date('d/m/Y', strtotime($fecha_hasta)); ?></p>
                
                <!-- Balance General -->
                <div class="balance-section">
                    <div class="balance-group">
                        <div class="balance-title text-primary">ACTIVOS</div>
                        <?php foreach ($activos as $cuenta): ?>
                            <div class="cuenta-item">
                                <span><?php echo htmlspecialchars($cuenta['nombre_cuenta']); ?></span>
                                <span><?php echo number_format($cuenta['saldo'], 0); ?></span>
                            </div>
                        <?php endforeach; ?>
                        <div class="cuenta-item">
                            <span>TOTAL ACTIVOS</span>
                            <span><?php echo number_format($total_activos, 0); ?></span>
                        </div>
                    </div>
                    
                    <div class="balance-group">
                        <div class="balance-title text-warning">PASIVOS</div>
                        <?php foreach ($pasivos as $cuenta): ?>
                            <div class="cuenta-item">
                                <span><?php echo htmlspecialchars($cuenta['nombre_cuenta']); ?></span>
                                <span><?php echo number_format(abs($cuenta['saldo']), 0); ?></span>
                            </div>
                        <?php endforeach; ?>
                        <div class="cuenta-item">
                            <span>TOTAL PASIVOS</span>
                            <span><?php echo number_format(abs($total_pasivos), 0); ?></span>
                        </div>
                        
                        <div class="balance-title text-info mt-3">PATRIMONIO</div>
                        <?php foreach ($patrimonio as $cuenta): ?>
                            <div class="cuenta-item">
                                <span><?php echo htmlspecialchars($cuenta['nombre_cuenta']); ?></span>
                                <span><?php echo number_format(abs($cuenta['saldo']), 0); ?></span>
                            </div>
                        <?php endforeach; ?>
                        <div class="cuenta-item">
                            <span>TOTAL PATRIMONIO</span>
                            <span><?php echo number_format(abs($total_patrimonio), 0); ?></span>
                        </div>
                    </div>
                </div>
                
                <!-- Estado de Resultados -->
                <div class="balance-section">
                    <div class="balance-group">
                        <div class="balance-title text-success">INGRESOS</div>
                        <?php foreach ($ingresos as $cuenta): ?>
                            <div class="cuenta-item">
                                <span><?php echo htmlspecialchars($cuenta['nombre_cuenta']); ?></span>
                                <span><?php echo number_format(abs($cuenta['saldo']), 0); ?></span>
                            </div>
                        <?php endforeach; ?>
                        <div class="cuenta-item">
                            <span>TOTAL INGRESOS</span>
                            <span><?php echo number_format(abs($total_ingresos), 0); ?></span>
                        </div>
                    </div>
                    
                    <div class="balance-group">
                        <div class="balance-title text-danger">GASTOS</div>
                        <?php foreach ($gastos as $cuenta): ?>
                            <div class="cuenta-item">
                                <span><?php echo htmlspecialchars($cuenta['nombre_cuenta']); ?></span>
                                <span><?php echo number_format($cuenta['saldo'], 0); ?></span>
                            </div>
                        <?php endforeach; ?>
                        <div class="cuenta-item">
                            <span>TOTAL GASTOS</span>
                            <span><?php echo number_format($total_gastos, 0); ?></span>
                        </div>
                        
                        <div class="cuenta-item bg-<?php echo $utilidad_perdida >= 0 ? 'success' : 'danger'; ?> text-white">
                            <span><?php echo $utilidad_perdida >= 0 ? 'UTILIDAD' : 'PÉRDIDA'; ?> DEL PERÍODO</span>
                            <span><?php echo number_format($utilidad_perdida, 0); ?></span>
                        </div>
                    </div>
                </div>
            </div>

        <?php elseif ($reporte === 'f29'): ?>
            <!-- Reporte F29 -->
            <div class="content-card">
                <h3><i class="fas fa-file-invoice-dollar"></i> Reporte F29 - Declaración Mensual IVA</h3>
                <p class="text-muted">Período: <?php echo date('m/Y', strtotime($fecha_desde)); ?></p>
                
                <div class="stats-row">
                    <div class="stat-item">
                        <div class="stat-value"><?php echo number_format($datos_ventas_f29['documentos_emitidos'] ?? 0); ?></div>
                        <div class="stat-label">Documentos Emitidos</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?php echo number_format($datos_ventas_f29['ventas_netas'] ?? 0, 0); ?></div>
                        <div class="stat-label">Ventas Netas</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?php echo number_format($datos_ventas_f29['iva_debito_fiscal'] ?? 0, 0); ?></div>
                        <div class="stat-label">IVA Débito Fiscal</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?php echo number_format($iva_credito, 0); ?></div>
                        <div class="stat-label">IVA Crédito Fiscal</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value text-<?php echo $iva_a_pagar > 0 ? 'danger' : 'success'; ?>">
                            <?php echo number_format($iva_a_pagar, 0); ?>
                        </div>
                        <div class="stat-label">IVA a Pagar</div>
                    </div>
                </div>
                
                <div class="alert alert-info">
                    <h5><i class="fas fa-info-circle"></i> Información F29</h5>
                    <p><strong>Período declarado:</strong> <?php echo date('m/Y', strtotime($fecha_desde)); ?></p>
                    <p><strong>Empresa:</strong> <?php echo htmlspecialchars($empresa['razon_social']); ?></p>
                    <p><strong>RUT:</strong> <?php echo htmlspecialchars($empresa['rut']); ?></p>
                    <p class="mb-0"><strong>Actividad Económica:</strong> <?php echo $empresa['actividad_economica'] ?? '749000'; ?></p>
                </div>
            </div>

        <?php elseif ($reporte === 'productos_vendidos'): ?>
            <!-- Productos Más Vendidos -->
            <div class="content-card">
                <h3><i class="fas fa-trophy"></i> Productos Más Vendidos</h3>
                <p class="text-muted">Período: <?php echo date('d/m/Y', strtotime($fecha_desde)); ?> - <?php echo date('d/m/Y', strtotime($fecha_hasta)); ?></p>
                
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Ranking</th>
                                <th>Código</th>
                                <th>Producto</th>
                                <th>Precio Unitario</th>
                                <th>Cantidad Vendida</th>
                                <th>Total Ventas</th>
                                <th>Documentos</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($productos_vendidos as $index => $producto): ?>
                                <tr>
                                    <td>
                                        <span class="badge bg-<?php 
                                            if ($index === 0) echo 'warning';
                                            elseif ($index < 3) echo 'success';
                                            else echo 'primary';
                                        ?>">
                                            #<?php echo $index + 1; ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($producto['codigo']); ?></td>
                                    <td><?php echo htmlspecialchars($producto['nombre']); ?></td>
                                    <td><?php echo number_format($producto['precio_venta'], 0); ?></td>
                                    <td><strong><?php echo number_format($producto['total_vendido']); ?></strong></td>
                                    <td><strong><?php echo number_format($producto['total_ventas'], 0); ?></strong></td>
                                    <td><?php echo $producto['documentos']; ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Animaciones de entrada
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.report-card, .stat-item');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                setTimeout(() => {
                    card.style.transition = 'all 0.6s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 100);
            });
        });
        
        // Efectos hover para las tarjetas de reporte
        document.querySelectorAll('.report-card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-10px) scale(1.02)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
            });
        });
    </script>
</body>
</html>