<?php
/*
=====================================================================================
CÓDIGO 1: CONFIGURACIÓN PRINCIPAL Y CONTROL DE ACCESO
1-configuracion.php / sistema/
SISCONECTA ERP - Sistema Integral de Servicios
Database: conectae_sisconecta | User: conectae_sisconectauser | Pass: pt125824caraud
Suscripción: $180 USD anuales - Usuario gratuito: AUDITOREX CHILE
=====================================================================================
*/

session_start();

// Configuración de base de datos
define('DB_HOST', 'localhost');
define('DB_NAME', 'conectae_sisconecta');
define('DB_USER', 'conectae_sisconectauser');
define('DB_PASS', 'pt125824caraud');

// Configuración del sistema
define('SISTEMA_NOMBRE', 'SISCONECTA ERP');
define('SISTEMA_VERSION', '1.0.0');
define('SUSCRIPCION_ANUAL', 180.00);
define('USUARIO_LIBRE', 'AUDITOREX CHILE');

class SistemaConfiguracion {
    private $pdo;
    private $usuario_actual;
    private $empresa_actual;
    
    public function __construct() {
        $this->conectarBD();
        $this->verificarSesion();
        $this->verificarSuscripcion();
    }
    
    private function conectarBD() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
            $this->pdo = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]);
        } catch (PDOException $e) {
            die("Error de conexión: " . $e->getMessage());
        }
    }
    
    private function verificarSesion() {
        if (!isset($_SESSION['usuario_id'])) {
            header('Location: login.php');
            exit;
        }
        
        $stmt = $this->pdo->prepare("
            SELECT u.*, e.* 
            FROM usuarios u 
            JOIN empresas e ON u.empresa_id = e.id 
            WHERE u.id = ? AND u.estado = 'activo'
        ");
        $stmt->execute([$_SESSION['usuario_id']]);
        $usuario = $stmt->fetch();
        
        if (!$usuario) {
            session_destroy();
            header('Location: login.php');
            exit;
        }
        
        $this->usuario_actual = $usuario;
        $this->empresa_actual = $usuario;
    }
    
    private function verificarSuscripcion() {
        // Verificar si la empresa no es gratuita y está vencida
        if ($this->empresa_actual['razon_social'] !== USUARIO_LIBRE) {
            $fecha_actual = date('Y-m-d');
            $fecha_vencimiento = $this->empresa_actual['fecha_vencimiento'];
            
            if ($fecha_actual > $fecha_vencimiento) {
                // Bloquear empresa vencida
                $stmt = $this->pdo->prepare("UPDATE empresas SET estado_suscripcion = 'vencido' WHERE id = ?");
                $stmt->execute([$this->empresa_actual['id']]);
                
                $this->mostrarPantallaVencimiento();
                exit;
            }
        }
    }
    
    private function mostrarPantallaVencimiento() {
        echo '<!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Suscripción Vencida - SISCONECTA ERP</title>
            <style>
                body { font-family: Arial, sans-serif; background: #f8f9fa; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
                .container { background: white; padding: 40px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); text-align: center; max-width: 500px; }
                .logo { font-size: 2em; color: #dc3545; margin-bottom: 20px; }
                .message { color: #666; margin: 20px 0; }
                .amount { font-size: 2em; color: #28a745; font-weight: bold; margin: 20px 0; }
                .btn { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; text-decoration: none; display: inline-block; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="logo">🚫 SUSCRIPCIÓN VENCIDA</div>
                <h2>' . $this->empresa_actual['razon_social'] . '</h2>
                <p class="message">Su suscripción a SISCONECTA ERP ha vencido el ' . $this->empresa_actual['fecha_vencimiento'] . '</p>
                <div class="amount">$180 USD</div>
                <p>Renovación anual requerida</p>
                <a href="mailto:ventas@sisconecta.com" class="btn">Renovar Suscripción</a>
                <br><br>
                <a href="logout.php">Cerrar Sesión</a>
            </div>
        </body>
        </html>';
    }
    
    public function procesarFormularios() {
        if ($_POST['action'] ?? '' === 'actualizar_empresa') {
            $this->actualizarEmpresa();
        } elseif ($_POST['action'] ?? '' === 'crear_usuario') {
            $this->crearUsuario();
        } elseif ($_POST['action'] ?? '' === 'configurar_caja') {
            $this->configurarCaja();
        }
    }
    
    private function actualizarEmpresa() {
        $stmt = $this->pdo->prepare("
            UPDATE empresas SET 
                razon_social = ?, giro = ?, direccion = ?, comuna = ?, 
                ciudad = ?, region = ?, telefono = ?, email = ?,
                codigo_actividad_economica = ?, regimen_tributario = ?,
                iva_defecto = ?, moneda_funcional = ?
            WHERE id = ?
        ");
        
        $stmt->execute([
            $_POST['razon_social'], $_POST['giro'], $_POST['direccion'], $_POST['comuna'],
            $_POST['ciudad'], $_POST['region'], $_POST['telefono'], $_POST['email'],
            $_POST['codigo_actividad'], $_POST['regimen_tributario'],
            $_POST['iva_defecto'], $_POST['moneda_funcional'],
            $this->empresa_actual['id']
        ]);
        
        $_SESSION['mensaje'] = "✅ Empresa actualizada correctamente";
    }
    
    private function crearUsuario() {
        // Crear usuario completamente aislado para la empresa actual
        $password_hash = password_hash($_POST['password'], PASSWORD_BCRYPT);
        
        $stmt = $this->pdo->prepare("
            INSERT INTO usuarios (
                empresa_id, username, password, nombre, apellido, 
                email, rut, cargo, permisos, estado
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, '{}', 'activo')
        ");
        
        $stmt->execute([
            $this->empresa_actual['id'],
            $_POST['username'], $password_hash, $_POST['nombre'], $_POST['apellido'],
            $_POST['email'], $_POST['rut'], $_POST['cargo']
        ]);
        
        $_SESSION['mensaje'] = "✅ Usuario creado correctamente";
    }
    
    private function configurarCaja() {
        $stmt = $this->pdo->prepare("
            INSERT INTO cajas (
                empresa_id, codigo_caja, nombre_caja, sucursal,
                moneda_principal, saldo_inicial, saldo_actual, usuario_responsable_id
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        ");
        
        $stmt->execute([
            $this->empresa_actual['id'],
            $_POST['codigo_caja'], $_POST['nombre_caja'], $_POST['sucursal'],
            $_POST['moneda_principal'], $_POST['saldo_inicial'], $_POST['saldo_inicial'],
            $this->usuario_actual['id']
        ]);
        
        $_SESSION['mensaje'] = "✅ Caja configurada correctamente";
    }
    
    public function obtenerUsuarios() {
        $stmt = $this->pdo->prepare("
            SELECT * FROM usuarios 
            WHERE empresa_id = ? AND id != ?
            ORDER BY nombre, apellido
        ");
        $stmt->execute([$this->empresa_actual['id'], $this->usuario_actual['id']]);
        return $stmt->fetchAll();
    }
    
    public function obtenerCajas() {
        $stmt = $this->pdo->prepare("
            SELECT c.*, u.nombre, u.apellido 
            FROM cajas c 
            LEFT JOIN usuarios u ON c.usuario_responsable_id = u.id
            WHERE c.empresa_id = ?
            ORDER BY c.codigo_caja
        ");
        $stmt->execute([$this->empresa_actual['id']]);
        return $stmt->fetchAll();
    }
    
    public function obtenerMonedas() {
        $stmt = $this->pdo->query("SELECT * FROM monedas WHERE estado = 'activo' ORDER BY codigo");
        return $stmt->fetchAll();
    }
}

$sistema = new SistemaConfiguracion();
$sistema->procesarFormularios();

// Obtener datos para mostrar
$usuarios = $sistema->obtenerUsuarios();
$cajas = $sistema->obtenerCajas();
$monedas = $sistema->obtenerMonedas();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuración - SISCONECTA ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --success-color: #27ae60;
            --danger-color: #e74c3c;
            --warning-color: #f39c12;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }

        .header-card {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }

        .logo {
            font-size: 2.5em;
            font-weight: bold;
            text-align: center;
            margin-bottom: 10px;
        }

        .subtitle {
            text-align: center;
            opacity: 0.9;
            font-size: 1.1em;
        }

        .company-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
            flex-wrap: wrap;
        }

        .subscription-status {
            background: rgba(255,255,255,0.2);
            padding: 10px 20px;
            border-radius: 10px;
            backdrop-filter: blur(10px);
        }

        .config-tabs {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }

        .nav-tabs {
            background: #f8f9fa;
            border-bottom: none;
            padding: 0;
        }

        .nav-tabs .nav-link {
            border: none;
            color: var(--primary-color);
            font-weight: 500;
            padding: 15px 25px;
            border-radius: 0;
            transition: all 0.3s ease;
        }

        .nav-tabs .nav-link.active {
            background: white;
            color: var(--secondary-color);
            border-bottom: 3px solid var(--secondary-color);
        }

        .nav-tabs .nav-link:hover {
            background: rgba(52, 152, 219, 0.1);
        }

        .tab-content {
            padding: 30px;
        }

        .form-control, .form-select {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--secondary-color);
            box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
        }

        .btn-custom {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 10px;
            font-weight: 500;
            transition: transform 0.2s ease;
        }

        .btn-custom:hover {
            transform: translateY(-2px);
            color: white;
        }

        .btn-success-custom {
            background: linear-gradient(135deg, var(--success-color) 0%, #229954 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 10px;
        }

        .btn-danger-custom {
            background: linear-gradient(135deg, var(--danger-color) 0%, #c0392b 100%);
            border: none;
            color: white;
            padding: 10px 20px;
            border-radius: 8px;
        }

        .stats-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-left: 5px solid var(--secondary-color);
        }

        .stats-number {
            font-size: 2.5em;
            font-weight: bold;
            color: var(--secondary-color);
        }

        .stats-label {
            color: #6c757d;
            font-size: 0.9em;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .table-custom {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }

        .table-custom thead {
            background: var(--secondary-color);
            color: white;
        }

        .table-custom thead th {
            border: none;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.85em;
        }

        .table-custom tbody tr {
            transition: background-color 0.2s ease;
        }

        .table-custom tbody tr:hover {
            background-color: rgba(52, 152, 219, 0.05);
        }

        .alert-custom {
            border: none;
            border-radius: 10px;
            padding: 15px 20px;
            margin-bottom: 20px;
        }

        .form-section {
            background: #f8f9fa;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .form-section h5 {
            color: var(--primary-color);
            margin-bottom: 20px;
            font-weight: 600;
        }

        .input-group-text {
            background: var(--secondary-color);
            color: white;
            border: none;
        }

        @media (max-width: 768px) {
            .company-info {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .main-container {
                padding: 10px;
            }
            
            .tab-content {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Header -->
        <div class="header-card">
            <div class="logo">SISCONECTA ERP</div>
            <div class="subtitle">Sistema Integral de Servicios Empresariales</div>
            
            <div class="company-info">
                <div>
                    <h4><i class="fas fa-building"></i> <?= htmlspecialchars($sistema->empresa_actual['razon_social']) ?></h4>
                    <p><i class="fas fa-id-card"></i> RUT: <?= htmlspecialchars($sistema->empresa_actual['rut_empresa']) ?>-<?= htmlspecialchars($sistema->empresa_actual['dv_empresa']) ?></p>
                </div>
                
                <div class="subscription-status">
                    <?php if ($sistema->empresa_actual['razon_social'] === USUARIO_LIBRE): ?>
                        <i class="fas fa-crown"></i> <strong>PLAN GRATUITO PERMANENTE</strong>
                    <?php else: ?>
                        <i class="fas fa-calendar-check"></i> <strong>Vence:</strong> <?= $sistema->empresa_actual['fecha_vencimiento'] ?>
                        <br><small>Plan Premium - $180 USD/año</small>
                    <?php endif; ?>
                </div>
                
                <div>
                    <strong><i class="fas fa-user"></i> <?= htmlspecialchars($sistema->usuario_actual['nombre']) ?> <?= htmlspecialchars($sistema->usuario_actual['apellido']) ?></strong>
                    <br><small><?= htmlspecialchars($sistema->usuario_actual['cargo']) ?></small>
                </div>
            </div>
        </div>

        <!-- Mensajes -->
        <?php if (isset($_SESSION['mensaje'])): ?>
            <div class="alert alert-success alert-custom">
                <i class="fas fa-check-circle"></i> <?= $_SESSION['mensaje'] ?>
            </div>
            <?php unset($_SESSION['mensaje']); ?>
        <?php endif; ?>

        <!-- Estadísticas rápidas -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="stats-number"><?= count($usuarios) + 1 ?></div>
                    <div class="stats-label">Usuarios Activos</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="stats-number"><?= count($cajas) ?></div>
                    <div class="stats-label">Cajas Configuradas</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="stats-number"><?= $sistema->empresa_actual['iva_defecto'] ?>%</div>
                    <div class="stats-label">IVA por Defecto</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="stats-number"><?= $sistema->empresa_actual['moneda_funcional'] ?></div>
                    <div class="stats-label">Moneda Principal</div>
                </div>
            </div>
        </div>

        <!-- Pestañas de configuración -->
        <div class="config-tabs">
            <ul class="nav nav-tabs" id="configTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="empresa-tab" data-bs-toggle="tab" data-bs-target="#empresa" type="button">
                        <i class="fas fa-building"></i> Empresa
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="usuarios-tab" data-bs-toggle="tab" data-bs-target="#usuarios" type="button">
                        <i class="fas fa-users"></i> Usuarios
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="cajas-tab" data-bs-toggle="tab" data-bs-target="#cajas" type="button">
                        <i class="fas fa-cash-register"></i> Cajas
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="monedas-tab" data-bs-toggle="tab" data-bs-target="#monedas" type="button">
                        <i class="fas fa-coins"></i> Monedas
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="configTabsContent">
                <!-- Pestaña Empresa -->
                <div class="tab-pane fade show active" id="empresa" role="tabpanel">
                    <form method="POST">
                        <input type="hidden" name="action" value="actualizar_empresa">
                        
                        <div class="form-section">
                            <h5><i class="fas fa-info-circle"></i> Información General</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="form-label">Razón Social</label>
                                    <input type="text" class="form-control" name="razon_social" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['razon_social']) ?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Giro</label>
                                    <input type="text" class="form-control" name="giro" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['giro']) ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-section">
                            <h5><i class="fas fa-map-marker-alt"></i> Ubicación</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="form-label">Dirección</label>
                                    <input type="text" class="form-control" name="direccion" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['direccion']) ?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Comuna</label>
                                    <input type="text" class="form-control" name="comuna" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['comuna']) ?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Ciudad</label>
                                    <input type="text" class="form-control" name="ciudad" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['ciudad']) ?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Región</label>
                                    <input type="text" class="form-control" name="region" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['region']) ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-section">
                            <h5><i class="fas fa-file-invoice-dollar"></i> Configuración Tributaria</h5>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Código Actividad Económica</label>
                                    <input type="text" class="form-control" name="codigo_actividad" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['codigo_actividad_economica']) ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Régimen Tributario</label>
                                    <select class="form-select" name="regimen_tributario">
                                        <option value="14A" <?= $sistema->empresa_actual['regimen_tributario'] === '14A' ? 'selected' : '' ?>>Artículo 14A</option>
                                        <option value="14B" <?= $sistema->empresa_actual['regimen_tributario'] === '14B' ? 'selected' : '' ?>>Artículo 14B</option>
                                        <option value="14D" <?= $sistema->empresa_actual['regimen_tributario'] === '14D' ? 'selected' : '' ?>>Artículo 14D</option>
                                        <option value="14ter" <?= $sistema->empresa_actual['regimen_tributario'] === '14ter' ? 'selected' : '' ?>>Artículo 14ter</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">IVA por Defecto (%)</label>
                                    <input type="number" class="form-control" name="iva_defecto" step="0.01" 
                                           value="<?= $sistema->empresa_actual['iva_defecto'] ?>" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Moneda Funcional</label>
                                    <select class="form-select" name="moneda_funcional">
                                        <?php foreach ($monedas as $moneda): ?>
                                            <option value="<?= $moneda['codigo'] ?>" 
                                                    <?= $sistema->empresa_actual['moneda_funcional'] === $moneda['codigo'] ? 'selected' : '' ?>>
                                                <?= $moneda['codigo'] ?> - <?= $moneda['nombre'] ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="form-section">
                            <h5><i class="fas fa-phone"></i> Contacto</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="form-label">Teléfono</label>
                                    <input type="text" class="form-control" name="telefono" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['telefono']) ?>">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" 
                                           value="<?= htmlspecialchars($sistema->empresa_actual['email']) ?>" required>
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-custom">
                            <i class="fas fa-save"></i> Actualizar Empresa
                        </button>
                    </form>
                </div>

                <!-- Pestaña Usuarios -->
                <div class="tab-pane fade" id="usuarios" role="tabpanel">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-user-plus"></i> Crear Nuevo Usuario</h5>
                            <form method="POST">
                                <input type="hidden" name="action" value="crear_usuario">
                                
                                <div class="mb-3">
                                    <label class="form-label">Nombre de Usuario</label>
                                    <input type="text" class="form-control" name="username" required>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label">Nombre</label>
                                        <input type="text" class="form-control" name="nombre" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Apellido</label>
                                        <input type="text" class="form-control" name="apellido" required>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" required>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label">RUT</label>
                                        <input type="text" class="form-control" name="rut">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Cargo</label>
                                        <input type="text" class="form-control" name="cargo">
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Contraseña</label>
                                    <input type="password" class="form-control" name="password" required>
                                </div>
                                
                                <button type="submit" class="btn btn-success-custom">
                                    <i class="fas fa-user-plus"></i> Crear Usuario
                                </button>
                            </form>
                        </div>
                        
                        <div class="col-md-6">
                            <h5><i class="fas fa-users"></i> Usuarios Existentes</h5>
                            <div class="table-responsive">
                                <table class="table table-custom">
                                    <thead>
                                        <tr>
                                            <th>Usuario</th>
                                            <th>Nombre</th>
                                            <th>Cargo</th>
                                            <th>Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($usuarios as $usuario): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($usuario['username']) ?></td>
                                                <td><?= htmlspecialchars($usuario['nombre'] . ' ' . $usuario['apellido']) ?></td>
                                                <td><?= htmlspecialchars($usuario['cargo']) ?></td>
                                                <td>
                                                    <span class="badge bg-<?= $usuario['estado'] === 'activo' ? 'success' : 'danger' ?>">
                                                        <?= ucfirst($usuario['estado']) ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pestaña Cajas -->
                <div class="tab-pane fade" id="cajas" role="tabpanel">
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-cash-register"></i> Configurar Nueva Caja</h5>
                            <form method="POST">
                                <input type="hidden" name="action" value="configurar_caja">
                                
                                <div class="mb-3">
                                    <label class="form-label">Código de Caja</label>
                                    <input type="text" class="form-control" name="codigo_caja" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Nombre de Caja</label>
                                    <input type="text" class="form-control" name="nombre_caja" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Sucursal</label>
                                    <input type="text" class="form-control" name="sucursal">
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label">Moneda Principal</label>
                                        <select class="form-select" name="moneda_principal">
                                            <?php foreach ($monedas as $moneda): ?>
                                                <option value="<?= $moneda['codigo'] ?>">
                                                    <?= $moneda['codigo'] ?> - <?= $moneda['nombre'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Saldo Inicial</label>
                                        <input type="number" class="form-control" name="saldo_inicial" step="0.01" value="0">
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-success-custom">
                                    <i class="fas fa-plus"></i> Crear Caja
                                </button>
                            </form>
                        </div>
                        
                        <div class="col-md-6">
                            <h5><i class="fas fa-list"></i> Cajas Configuradas</h5>
                            <div class="table-responsive">
                                <table class="table table-custom">
                                    <thead>
                                        <tr>
                                            <th>Código</th>
                                            <th>Nombre</th>
                                            <th>Moneda</th>
                                            <th>Saldo</th>
                                            <th>Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($cajas as $caja): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($caja['codigo_caja']) ?></td>
                                                <td><?= htmlspecialchars($caja['nombre_caja']) ?></td>
                                                <td><?= htmlspecialchars($caja['moneda_principal']) ?></td>
                                                <td><?= number_format($caja['saldo_actual'], 2) ?></td>
                                                <td>
                                                    <span class="badge bg-<?= $caja['estado'] === 'activo' ? 'success' : 'danger' ?>">
                                                        <?= ucfirst($caja['estado']) ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pestaña Monedas -->
                <div class="tab-pane fade" id="monedas" role="tabpanel">
                    <h5><i class="fas fa-coins"></i> Monedas Disponibles</h5>
                    <div class="table-responsive">
                        <table class="table table-custom">
                            <thead>
                                <tr>
                                    <th>Código</th>
                                    <th>Nombre</th>
                                    <th>Símbolo</th>
                                    <th>Decimales</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($monedas as $moneda): ?>
                                    <tr>
                                        <td><strong><?= htmlspecialchars($moneda['codigo']) ?></strong></td>
                                        <td><?= htmlspecialchars($moneda['nombre']) ?></td>
                                        <td><?= htmlspecialchars($moneda['simbolo']) ?></td>
                                        <td><?= $moneda['decimales'] ?></td>
                                        <td>
                                            <span class="badge bg-success">Activo</span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navegación a otros módulos -->
        <div class="row mt-4">
            <div class="col-md-3">
                <a href="2-contabilidad.php" class="btn btn-custom w-100">
                    <i class="fas fa-calculator"></i> Módulo Contabilidad
                </a>
            </div>
            <div class="col-md-3">
                <a href="3-facturacion.php" class="btn btn-custom w-100">
                    <i class="fas fa-file-invoice"></i> Facturación
                </a>
            </div>
            <div class="col-md-3">
                <a href="4-inventario.php" class="btn btn-custom w-100">
                    <i class="fas fa-boxes"></i> Inventario
                </a>
            </div>
            <div class="col-md-3">
                <a href="5-punto-venta.php" class="btn btn-custom w-100">
                    <i class="fas fa-cash-register"></i> Punto de Venta
                </a>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>